/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;

public class DeferredDamage {
    private static Map<Entity, Entry> entries = new HashMap<Entity, Entry>();

    public static void hurt(Entity target, DamageSource source, float damage, float igniteSeconds) {
        Entry entry = entries.get(target);
        if (entry == null) {
            entry = new Entry();
            entries.put(target, entry);
        }
        entry.source = source;
        entry.damage += damage;
        entry.igniteSeconds = Math.min(5.0f, entry.igniteSeconds + igniteSeconds);
    }

    public static void apply() {
        entries.forEach((target, entry) -> {
            target.f_19802_ = 0;
            target.m_6469_(entry.source, entry.damage);
            if (entry.igniteSeconds > 0.0f) {
                target.m_20254_((int)entry.igniteSeconds);
            }
        });
        entries.clear();
    }

    private static class Entry {
        DamageSource source;
        float damage;
        float igniteSeconds;

        private Entry() {
        }
    }
}

