/*
 * Decompiled with CFR 0.152.
 */
package zeh.createlowheated.content.processing.basicburner;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlock;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import zeh.createlowheated.AllBlockEntityTypes;
import zeh.createlowheated.AllShapes;
import zeh.createlowheated.AllTags;
import zeh.createlowheated.common.Configuration;
import zeh.createlowheated.content.processing.basicburner.BasicBurnerBlockEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BasicBurnerBlock
extends HorizontalDirectionalBlock
implements IBE<BasicBurnerBlockEntity>,
IWrenchable {
    public static final EnumProperty<BlazeBurnerBlock.HeatLevel> HEAT_LEVEL = EnumProperty.m_61587_((String)"low", BlazeBurnerBlock.HeatLevel.class);
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty FUELED = BooleanProperty.m_61465_((String)"fueled");
    public static final BooleanProperty EMPOWERED = BooleanProperty.m_61465_((String)"empowered");

    public BasicBurnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.NONE)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FUELED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EMPOWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HEAT_LEVEL, LIT, FUELED, EMPOWERED, f_54117_});
        super.m_7926_(builder);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos.m_7494_());
        if (!(blockEntity instanceof BasinBlockEntity)) {
            return;
        }
        BasinBlockEntity basin = (BasinBlockEntity)blockEntity;
        basin.notifyChangeOfContents();
    }

    public Class<BasicBurnerBlockEntity> getBlockEntityClass() {
        return BasicBurnerBlockEntity.class;
    }

    public BlockEntityType<? extends BasicBurnerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.BASIC_HEATER.get();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return super.m_142194_(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        ItemStack heldItem = player.m_21120_(hand);
        boolean wasEmptyHanded = heldItem.m_41619_() && hand == InteractionHand.MAIN_HAND;
        boolean shouldntPlaceItem = AllBlocks.MECHANICAL_ARM.isIn(heldItem);
        if (!state.m_155947_()) {
            return InteractionResult.PASS;
        }
        BlockEntity be = world.m_7702_(pos);
        if (!(be instanceof BasicBurnerBlockEntity)) {
            return InteractionResult.PASS;
        }
        BasicBurnerBlockEntity burnerBE = (BasicBurnerBlockEntity)be;
        if (!burnerBE.inputInv.getStackInSlot(0).m_41619_() && !((Boolean)state.m_61143_((Property)LIT)).booleanValue() && heldItem.m_204117_(AllTags.AllItemTags.BURNER_STARTERS.tag)) {
            world.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, world.f_46441_.m_188501_() * 0.4f + 0.8f);
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            heldItem.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
            burnerBE.notifyUpdate();
            return InteractionResult.SUCCESS;
        }
        ItemStack mainItemStack = burnerBE.inputInv.getStackInSlot(0);
        if (!mainItemStack.m_41619_() && wasEmptyHanded) {
            player.m_150109_().m_150079_(mainItemStack);
            burnerBE.inputInv.setStackInSlot(0, ItemStack.f_41583_);
            world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f + Create.RANDOM.nextFloat());
        }
        if (!wasEmptyHanded && !shouldntPlaceItem) {
            ItemStack remainder = burnerBE.itemHandler.insertItem(0, heldItem.m_41777_(), false);
            if (remainder.m_41613_() == heldItem.m_41613_()) {
                return InteractionResult.PASS;
            }
            player.m_21008_(hand, remainder);
            AllSoundEvents.DEPOT_SLIDE.playOnServer(world, (Vec3i)pos);
        }
        burnerBE.notifyUpdate();
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean isEmpowered = false;
        for (Direction side : Iterate.directions) {
            if (!side.m_122434_().m_122479_()) continue;
            BlockPos burnerPos = context.m_8083_();
            BlockPos fanPos = burnerPos.m_121945_(side);
            BlockEntity fan = context.m_43725_().m_7702_(fanPos);
            if (!(fan instanceof EncasedFanBlockEntity)) continue;
            EncasedFanBlockEntity fanBE = (EncasedFanBlockEntity)fan;
            Direction fanFacingDir = (Direction)fan.m_58900_().m_61143_((Property)EncasedFanBlock.FACING);
            BlockPos fanFacingPos = fanPos.m_121945_(fanFacingDir);
            if (!burnerPos.equals((Object)fanFacingPos)) continue;
            isEmpowered = Mth.m_14154_((float)fanBE.getSpeed()) >= (float)((Integer)Configuration.FAN_SPEED_REQUIRED.get()).intValue();
        }
        return (BlockState)super.m_5573_(context).m_61124_((Property)EMPOWERED, (Comparable)Boolean.valueOf(isEmpowered));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return AllShapes.BASIC_HEATER_BLOCK_SHAPE;
    }

    public VoxelShape m_5939_(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        return this.m_5940_(p_220071_1_, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    public boolean m_7278_(BlockState p_149740_1_) {
        return true;
    }

    public int m_6782_(BlockState state, Level p_180641_2_, BlockPos p_180641_3_) {
        return Math.max(0, ((BlazeBurnerBlock.HeatLevel)state.m_61143_(HEAT_LEVEL)).ordinal() - 1);
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, Random random) {
        if (random.nextInt(10) != 0) {
            return;
        }
        if (!((BlazeBurnerBlock.HeatLevel)state.m_61143_(HEAT_LEVEL)).equals((Object)BlazeBurnerBlock.HeatLevel.NONE)) {
            return;
        }
        world.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
    }

    public static BlazeBurnerBlock.HeatLevel getHeatLevelOf(BlockState blockState) {
        return blockState.m_61138_(HEAT_LEVEL) ? (BlazeBurnerBlock.HeatLevel)blockState.m_61143_(HEAT_LEVEL) : BlazeBurnerBlock.HeatLevel.NONE;
    }

    public static boolean getLitOf(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)LIT);
    }

    public static boolean getEmpoweredOf(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)EMPOWERED);
    }

    public static int getLight(BlockState state) {
        BlazeBurnerBlock.HeatLevel level = (BlazeBurnerBlock.HeatLevel)state.m_61143_(HEAT_LEVEL);
        return switch (level) {
            case BlazeBurnerBlock.HeatLevel.NONE -> 0;
            default -> 15;
        };
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        if (!entityIn.m_6084_()) {
            return;
        }
        if (entityIn.m_9236_().f_46443_) {
            return;
        }
        BasicBurnerBlockEntity burner = null;
        for (BlockPos pos : Iterate.hereAndBelow((BlockPos)entityIn.m_20183_())) {
            if (burner != null) continue;
            burner = (BasicBurnerBlockEntity)this.getBlockEntity(worldIn, pos);
        }
        if (burner == null) {
            return;
        }
        LazyOptional capability = burner.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (!capability.isPresent()) {
            return;
        }
        ItemStack remainder = ((IItemHandler)capability.orElse((Object)new ItemStackHandler())).insertItem(0, itemEntity.m_32055_(), false);
        if (remainder.m_41619_()) {
            itemEntity.m_146870_();
        }
        if (remainder.m_41613_() < itemEntity.m_32055_().m_41613_()) {
            itemEntity.m_32045_(remainder);
        }
    }
}

