/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.optifine;

import java.util.ArrayList;
import java.util.List;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathMethod;

public class MaxMethod
extends MathMethod {
    public MaxMethod(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        List<MathComponent> parsedArgs = MaxMethod.parseAllArgs(args, calculationInstance);
        MathComponent initial = parsedArgs.get(0);
        ArrayList<MathComponent> theRest = new ArrayList<MathComponent>(parsedArgs);
        theRest.remove(0);
        this.setSupplierAndOptimize(() -> {
            float max = initial.getResult();
            for (MathComponent parsedArg : theRest) {
                float val = parsedArg.getResult();
                if (!(val > max)) continue;
                max = val;
            }
            return max;
        }, parsedArgs);
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount >= 2;
    }
}

