/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditionsClient;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.SlotlessableItemHandlerWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public final class WorldUtil {
    public static boolean doItemInteraction(SlotlessableItemHandlerWrapper extractWrapper, SlotlessableItemHandlerWrapper insertWrapper, int maxExtract) {
        return WorldUtil.doItemInteraction(extractWrapper, insertWrapper, maxExtract, null);
    }

    public static boolean doItemInteraction(SlotlessableItemHandlerWrapper extractWrapper, SlotlessableItemHandlerWrapper insertWrapper, int maxExtract, FilterSettings filter) {
        return WorldUtil.doItemInteraction(extractWrapper, insertWrapper, maxExtract, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, filter);
    }

    public static boolean doItemInteraction(SlotlessableItemHandlerWrapper extractWrapper, SlotlessableItemHandlerWrapper insertWrapper, int maxExtract, int extractSlotStart, int extractSlotEnd, int insertSlotStart, int insertSlotEnd, FilterSettings filter) {
        ItemStack remaining;
        ItemStack theoreticalExtract = WorldUtil.extractItem(extractWrapper, maxExtract, true, extractSlotStart, extractSlotEnd, filter);
        if (StackUtil.isValid(theoreticalExtract) && !ItemStack.m_41728_((ItemStack)(remaining = StackUtil.insertItem(insertWrapper, theoreticalExtract, false, insertSlotStart, insertSlotEnd)), (ItemStack)theoreticalExtract)) {
            int toExtract = theoreticalExtract.m_41613_() - remaining.m_41613_();
            WorldUtil.extractItem(extractWrapper, toExtract, false, extractSlotStart, extractSlotEnd, filter);
            return true;
        }
        return false;
    }

    public static ItemStack extractItem(SlotlessableItemHandlerWrapper extractWrapper, int maxExtract, boolean simulate, int slotStart, int slotEnd, FilterSettings filter) {
        LazyOptional<IItemHandler> handler;
        ItemStack extracted = ItemStack.f_41583_;
        if (ActuallyAdditions.commonCapsLoaded) {
            // empty if block
        }
        if (!StackUtil.isValid(extracted) && (handler = extractWrapper.getNormalHandler()).isPresent()) {
            for (int i = Math.max(0, slotStart); i < Math.min(slotEnd, ((IItemHandler)handler.resolve().get()).getSlots()) && (filter != null && filter.needsCheck() && !filter.check(((IItemHandler)handler.resolve().get()).getStackInSlot(i)) || !StackUtil.isValid(extracted = ((IItemHandler)handler.resolve().get()).extractItem(i, maxExtract, simulate))); ++i) {
            }
        }
        return extracted;
    }

    public static void doEnergyInteraction(BlockEntity tileFrom, BlockEntity tileTo, Direction sideTo, int maxTransfer) {
        if (maxTransfer > 0) {
            Direction opp = sideTo == null ? null : sideTo.m_122424_();
            LazyOptional handlerFrom = tileFrom.getCapability(ForgeCapabilities.ENERGY, sideTo);
            LazyOptional handlerTo = tileTo.getCapability(ForgeCapabilities.ENERGY, opp);
            handlerFrom.ifPresent(from -> handlerTo.ifPresent(to -> {
                int drain = from.extractEnergy(maxTransfer, true);
                if (drain > 0) {
                    int filled = to.receiveEnergy(drain, false);
                    from.extractEnergy(filled, false);
                }
            }));
        }
    }

    public static void doFluidInteraction(BlockEntity tileFrom, BlockEntity tileTo, Direction sideTo, int maxTransfer) {
        if (maxTransfer > 0) {
            LazyOptional optionalFrom = tileFrom.getCapability(ForgeCapabilities.FLUID_HANDLER, sideTo);
            LazyOptional optionalTo = tileTo.getCapability(ForgeCapabilities.FLUID_HANDLER, sideTo.m_122424_());
            optionalFrom.ifPresent(from -> optionalTo.ifPresent(to -> {
                FluidStack drain = from.drain(maxTransfer, IFluidHandler.FluidAction.SIMULATE);
                if (!drain.isEmpty()) {
                    int filled = to.fill(drain.copy(), IFluidHandler.FluidAction.EXECUTE);
                    from.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                }
            }));
        }
    }

    public static boolean hasBlocksInPlacesGiven(BlockPos[] positions, Block block, Level level) {
        for (BlockPos pos : positions) {
            BlockState state = level.m_8055_(pos);
            if (state.m_60734_() == block) continue;
            return false;
        }
        return true;
    }

    public static ItemStack useItemAtSide(Direction side, Level level, BlockPos pos, ItemStack stack) {
        if (level instanceof ServerLevel && StackUtil.isValid(stack) && pos != null) {
            BlockPos offsetPos = pos.m_121945_(side);
            BlockState state = level.m_8055_(offsetPos);
            Block block = state.m_60734_();
            boolean replaceable = false;
            if (replaceable && stack.m_41720_() == Items.f_42451_) {
                level.m_7731_(offsetPos, Blocks.f_50088_.m_49966_(), 2);
                return StackUtil.shrink(stack, 1);
            }
            try {
                FakePlayer fake = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)level));
                WorldUtil.setHandItemWithoutAnnoyingSound((Player)fake, InteractionHand.MAIN_HAND, stack.m_41777_());
                BlockHitResult ray = new BlockHitResult(new Vec3(0.5, 0.5, 0.5), side.m_122424_(), offsetPos, true);
                fake.f_8941_.m_7179_((ServerPlayer)fake, level, fake.m_21205_(), InteractionHand.MAIN_HAND, ray);
                ItemStack result = fake.m_21120_(InteractionHand.MAIN_HAND);
                return result;
            }
            catch (Exception e) {
                ActuallyAdditions.LOGGER.error("Something that places Blocks at " + offsetPos.m_123341_() + ", " + offsetPos.m_123342_() + ", " + offsetPos.m_123343_() + " in World " + level.m_46472_() + " threw an Exception! Don't let that happen again!", (Throwable)e);
            }
        }
        return stack;
    }

    public static boolean dropItemAtSide(Direction side, Level level, BlockPos pos, ItemStack stack) {
        BlockPos coords = pos.m_121945_(side);
        if (level.m_46805_(coords)) {
            ItemEntity item = new ItemEntity(level, (double)coords.m_123341_() + 0.5, (double)coords.m_123342_() + 0.5, (double)coords.m_123343_() + 0.5, stack);
            item.m_20334_(0.0, 0.0, 0.0);
            return level.m_7967_((Entity)item);
        }
        return false;
    }

    public static Direction getDirectionBySidesInOrder(int side) {
        switch (side) {
            case 0: {
                return Direction.UP;
            }
            case 1: {
                return Direction.DOWN;
            }
            case 2: {
                return Direction.NORTH;
            }
            case 3: {
                return Direction.EAST;
            }
            case 4: {
                return Direction.SOUTH;
            }
        }
        return Direction.WEST;
    }

    public static Direction getDirectionByPistonRotation(BlockState state) {
        return (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
    }

    public static ArrayList<BlockState> getStatesAround(Level level, BlockPos pos) {
        ArrayList<BlockState> blocks = new ArrayList<BlockState>();
        blocks.add(level.m_8055_(pos.m_121945_(Direction.NORTH)));
        blocks.add(level.m_8055_(pos.m_121945_(Direction.EAST)));
        blocks.add(level.m_8055_(pos.m_121945_(Direction.SOUTH)));
        blocks.add(level.m_8055_(pos.m_121945_(Direction.WEST)));
        return blocks;
    }

    public static void setHandItemWithoutAnnoyingSound(Player player, InteractionHand hand, ItemStack stack) {
        if (hand == InteractionHand.MAIN_HAND) {
            player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)stack);
        } else if (hand == InteractionHand.OFF_HAND) {
            player.m_150109_().f_35976_.set(0, (Object)stack);
        }
    }

    public static float fireFakeHarvestEventsForDropChance(BlockEntity caller, List<ItemStack> drops, Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            FakePlayer fake = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)level));
            BlockPos tePos = caller.m_58899_();
            fake.m_6034_((double)tePos.m_123341_() + 0.5, (double)tePos.m_123342_() + 0.5, (double)tePos.m_123343_() + 0.5);
            BlockState state = level.m_8055_(pos);
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, (Player)fake);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                return ForgeEventFactory.doPlayerHarvestCheck((Player)fake, (BlockState)state, (boolean)true) ? 1.0f : 0.0f;
            }
        }
        return 0.0f;
    }

    public static boolean breakExtraBlock(ItemStack stack, Level level, Player player, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (player.m_7500_()) {
            if (block.onDestroyedByPlayer(state, level, pos, player, false, state.m_60819_())) {
                block.m_6786_((LevelAccessor)level, pos, state);
            }
            if (!level.f_46443_) {
                // empty if block
            }
            return true;
        }
        stack.m_41686_(level, state, pos, player);
        if (!level.f_46443_) {
            int xp = ForgeHooks.onBlockBreakEvent((Level)level, (GameType)((ServerPlayer)player).f_8941_.m_9290_(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos);
            if (xp == -1) {
                return false;
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (block.onDestroyedByPlayer(state, level, pos, player, true, state.m_60819_())) {
                block.m_6786_((LevelAccessor)level, pos, state);
                block.m_6240_(level, player, pos, state, blockEntity, stack);
                block.m_49805_((ServerLevel)level, pos, xp);
            }
            return true;
        }
        level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        if (block.onDestroyedByPlayer(state, level, pos, player, true, state.m_60819_())) {
            block.m_6786_((LevelAccessor)level, pos, state);
        }
        stack.m_41686_(level, state, pos, player);
        ActuallyAdditionsClient.sendBreakPacket(pos);
        return true;
    }
}

