/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.commons.lang3.StringUtils;

public class RefHelp {
    public static Field findField(Class<?> clazz, String ... fieldNames) {
        Exception failed = null;
        for (String fieldName : fieldNames) {
            try {
                Field f = clazz.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
            catch (Exception e) {
                failed = e;
            }
        }
        throw new UnableToFindFieldException(fieldNames, failed);
    }

    @Nonnull
    public static Field findField(@Nonnull Class<?> clazz, @Nonnull String fieldName, @Nullable String fieldObfName) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)fieldName), (Object)"Field name cannot be empty");
        String nameToFind = !FMLLoader.isProduction() ? fieldName : (String)MoreObjects.firstNonNull((Object)fieldObfName, (Object)fieldName);
        try {
            Field f = clazz.getDeclaredField(nameToFind);
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            throw new UnableToFindFieldException(e);
        }
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, @Nullable E instance, int fieldIndex) {
        try {
            Field f = classToAccess.getDeclaredFields()[fieldIndex];
            f.setAccessible(true);
            return (T)f.get(instance);
        }
        catch (Exception e) {
            throw new UnableToAccessFieldException(e);
        }
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, String ... fieldNames) {
        try {
            return (T)RefHelp.findField(classToAccess, fieldNames).get(instance);
        }
        catch (Exception e) {
            throw new UnableToAccessFieldException(fieldNames, e);
        }
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, @Nullable E instance, String fieldName, @Nullable String fieldObfName) {
        try {
            return (T)RefHelp.findField(classToAccess, fieldName, fieldObfName).get(instance);
        }
        catch (Exception e) {
            throw new UnableToAccessFieldException(e);
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, int fieldIndex) {
        try {
            Field f = classToAccess.getDeclaredFields()[fieldIndex];
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Exception e) {
            throw new UnableToAccessFieldException(e);
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, String ... fieldNames) {
        try {
            RefHelp.findField(classToAccess, fieldNames).set(instance, value);
        }
        catch (Exception e) {
            throw new UnableToAccessFieldException(fieldNames, e);
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, @Nullable T instance, @Nullable E value, String fieldName, @Nullable String fieldObfName) {
        try {
            RefHelp.findField(classToAccess, fieldName, fieldObfName).set(instance, value);
        }
        catch (Exception e) {
            throw new UnableToAccessFieldException(e);
        }
    }

    public static Class<? super Object> getClass(ClassLoader loader, String ... classNames) {
        Exception err = null;
        for (String className : classNames) {
            try {
                return Class.forName(className, false, loader);
            }
            catch (Exception e) {
                err = e;
            }
        }
        throw new UnableToFindClassException(classNames, err);
    }

    @Nonnull
    public static Method findMethod(@Nonnull Class<?> clazz, @Nonnull String methodName, @Nullable String methodObfName, Class<?> ... parameterTypes) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)methodName), (Object)"Method name cannot be empty");
        String nameToFind = !FMLLoader.isProduction() ? methodName : (String)MoreObjects.firstNonNull((Object)methodObfName, (Object)methodName);
        try {
            Method m = clazz.getDeclaredMethod(nameToFind, parameterTypes);
            m.setAccessible(true);
            return m;
        }
        catch (Exception e) {
            throw new UnableToFindMethodException(e);
        }
    }

    @Nonnull
    public static <T> Constructor<T> findConstructor(@Nonnull Class<T> klass, Class<?> ... parameterTypes) {
        Preconditions.checkNotNull(klass, (Object)"class");
        Preconditions.checkNotNull(parameterTypes, (Object)"parameter types");
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            StringBuilder desc = new StringBuilder();
            desc.append(klass.getSimpleName());
            StringJoiner joiner = new StringJoiner(", ", "(", ")");
            for (Class<?> type : parameterTypes) {
                joiner.add(type.getSimpleName());
            }
            desc.append(joiner);
            throw new UnknownConstructorException("Could not find constructor '" + desc.toString() + "' in " + klass);
        }
    }

    public static class UnableToFindFieldException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnableToFindFieldException(String[] fieldNameList, Exception e) {
            super(e);
        }

        public UnableToFindFieldException(Exception e) {
            super(e);
        }
    }

    public static class UnableToAccessFieldException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnableToAccessFieldException(String[] fieldNames, Exception e) {
            super(e);
        }

        public UnableToAccessFieldException(Exception e) {
            super(e);
        }
    }

    public static class UnableToFindClassException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnableToFindClassException(String[] classNames, @Nullable Exception err) {
            super(err);
        }
    }

    public static class UnableToFindMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnableToFindMethodException(String[] methodNames, Exception failed) {
            super(failed);
        }

        public UnableToFindMethodException(Throwable failed) {
            super(failed);
        }
    }

    public static class UnknownConstructorException
    extends RuntimeException {
        public UnknownConstructorException(String message) {
            super(message);
        }
    }
}

