/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import de.ellpeck.actuallyadditions.mod.blocks.render.RenderTypes;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketServerToClient;
import de.ellpeck.actuallyadditions.mod.particle.ParticleBeam;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.network.PacketDistributor;
import org.joml.Matrix4f;

public final class AssetUtil {
    public static final int MAX_LIGHT_X = 0xF000F0;
    public static final int MAX_LIGHT_Y = 0xF000F0;
    public static final ResourceLocation GUI_INVENTORY_LOCATION = AssetUtil.getGuiLocation("gui_inventory");
    private static final ResourceLocation FORGE_WHITE = new ResourceLocation("forge", "white");

    public static ResourceLocation getGuiLocation(String file) {
        return new ResourceLocation("actuallyadditions", "textures/gui/" + file + ".png");
    }

    public static ResourceLocation getBookletGuiLocation(String file) {
        return AssetUtil.getGuiLocation("booklet/" + file);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void displayNameString(GuiGraphics guiGraphics, Font font, int xSize, int yPositionOfMachineText, String text) {
        guiGraphics.drawString(font, text, (float)xSize / 2.0f - (float)font.m_92895_(text) / 2.0f, (float)yPositionOfMachineText, 0xFFFFFF, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void displayNameString(GuiGraphics guiGraphics, Font font, int xSize, int yPositionOfMachineText, TileEntityBase tile) {
        AssetUtil.displayNameString(guiGraphics, font, xSize, yPositionOfMachineText, I18n.m_118938_((String)tile.getNameForTranslation(), (Object[])new Object[0]));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemInWorld(ItemStack stack, int combinedLight, int combinedOverlay, PoseStack matrices, MultiBufferSource buffer) {
        if (!stack.m_41619_()) {
            Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, matrices, buffer, null, 0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemWithoutScrewingWithColors(ItemStack stack, PoseStack matrices, int combinedOverlay, int combinedLight) {
        if (StackUtil.isValid(stack)) {
            Minecraft mc = Minecraft.m_91087_();
            ItemRenderer renderer = mc.m_91291_();
            TextureManager manager = mc.m_91097_();
            MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
            BakedModel model = renderer.m_174264_(stack, null, null, 0);
            manager.m_174784_(TextureAtlas.f_118259_);
            manager.m_118506_(TextureAtlas.f_118259_).setBlurMipmap(false, false);
            RenderSystem.enableBlend();
            matrices.m_85836_();
            model = ForgeHooksClient.handleCameraTransforms((PoseStack)matrices, (BakedModel)model, (ItemDisplayContext)ItemDisplayContext.FIXED, (boolean)false);
            renderer.m_115143_(stack, ItemDisplayContext.FIXED, false, matrices, (MultiBufferSource)bufferSource, combinedOverlay, combinedLight, model);
            matrices.m_85849_();
            RenderSystem.disableBlend();
            manager.m_174784_(TextureAtlas.f_118259_);
            manager.m_118506_(TextureAtlas.f_118259_).restoreLastBlurMipmap();
            bufferSource.m_109911_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderStackToGui(ItemStack stack, int x, int y, float scale) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawHorizontalGradientRect(int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
    }

    public static void spawnLaserWithTimeServer(Level world, double startX, double startY, double startZ, double endX, double endY, double endZ, int color, int maxAge, double rotationTime, float size, float alpha) {
        if (!world.f_46443_) {
            CompoundTag data = new CompoundTag();
            data.m_128347_("StartX", startX);
            data.m_128347_("StartY", startY);
            data.m_128347_("StartZ", startZ);
            data.m_128347_("EndX", endX);
            data.m_128347_("EndY", endY);
            data.m_128347_("EndZ", endZ);
            data.m_128405_("Color", color);
            data.m_128347_("RotationTime", rotationTime);
            data.m_128350_("Size", size);
            data.m_128405_("MaxAge", maxAge);
            data.m_128350_("Alpha", alpha);
            PacketHandler.THE_NETWORK.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(startX, startY, startZ, 96.0, world.m_46472_())), (Object)new PacketServerToClient(data, PacketHandler.LASER_HANDLER));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnLaserWithTimeClient(double startX, double startY, double startZ, double endX, double endY, double endZ, int color, int maxAge, double rotationTime, float size, float alpha) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91074_.m_20275_(startX, startY, startZ) <= 64.0 || mc.f_91074_.m_20275_(endX, endY, endZ) <= 64.0) {
            mc.f_91073_.m_7106_(ParticleBeam.Factory.createData(endX, endY, endZ, color, alpha, maxAge, rotationTime, size), startX, startY, startZ, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderLaser(PoseStack matrixStack, MultiBufferSource buffer, float offX, float offY, float offZ, float yaw, float pitch, float length, float rotationTime, int color, float alpha, float beamWidth) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        int r = (int)((float)(color >> 16 & 0xFF) * alpha);
        int g = (int)((float)(color >> 8 & 0xFF) * alpha);
        int b = (int)((float)(color & 0xFF) * alpha);
        int a = 255;
        int lightmap = LightTexture.m_109885_((int)0xF000F0, (int)0xF000F0);
        float roll = rotationTime > 0.0f ? 360.0f * ((float)world.m_46467_() % rotationTime / rotationTime) : 0.0f;
        VertexConsumer builder = buffer.m_6299_(RenderTypes.LASER);
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.5f, 0.5f, 0.5f);
        matrixStack.m_252880_(offX, offY, offZ);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(yaw));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(roll));
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(FORGE_WHITE);
        float minU = sprite.m_118409_();
        float maxU = sprite.m_118410_();
        float minV = sprite.m_118411_();
        float maxV = sprite.m_118412_();
        for (int i = 1; i < 4; ++i) {
            float width = beamWidth * ((float)i / 4.0f);
            builder.m_252986_(matrix, -width, width, 0.0f).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, width, width, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, width, width, -length).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, -width, width, -length).m_6122_(r, g, b, a).m_7421_(minU, minV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, -width, -width, 0.0f).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, -width, -width, -length).m_6122_(r, g, b, a).m_7421_(minU, minV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, width, -width, -length).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, width, -width, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, -width, width, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, -width, -width, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, -width, -width, -length).m_6122_(r, g, b, a).m_7421_(minU, minV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, -width, width, -length).m_6122_(r, g, b, a).m_7421_(minU, minV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, width, width, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, width, -width, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, width, -width, -length).m_6122_(r, g, b, a).m_7421_(minU, minV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, width, width, -length).m_6122_(r, g, b, a).m_7421_(minU, minV).m_85969_(lightmap).m_5752_();
        }
        matrixStack.m_85849_();
    }

    public static void renderLaser(PoseStack matrixStack, MultiBufferSource buffer, Vec3 startOffset, Vec3 endOffset, float rotationTime, int color, float alpha, float beamWidth) {
        Vec3 combined = endOffset.m_82546_(startOffset);
        double pitch = Math.toDegrees(Math.atan2(combined.f_82480_, Math.sqrt(combined.f_82479_ * combined.f_82479_ + combined.f_82481_ * combined.f_82481_)));
        double yaw = Math.toDegrees(Math.atan2(-combined.f_82481_, combined.f_82479_));
        double length = combined.m_82553_();
        AssetUtil.renderLaser(matrixStack, buffer, (float)startOffset.f_82479_, (float)startOffset.f_82480_, (float)startOffset.f_82481_, (float)yaw, (float)pitch, (float)length, rotationTime, color, alpha, beamWidth);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderLaserParticle(VertexConsumer builder, Camera camera, double firstX, double firstY, double firstZ, double secondX, double secondY, double secondZ, float rotationTime, float a, float beamWidth, float[] color) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        Vec3 cam = camera.m_90583_();
        float r = color[0];
        float g = color[1];
        float b = color[2];
        Vec3 vec1 = new Vec3(firstX, firstY, firstZ);
        Vec3 vec2 = new Vec3(secondX, secondY, secondZ);
        Vec3 combinedVec = vec2.m_82546_(vec1);
        int lightmap = LightTexture.m_109885_((int)0xF000F0, (int)0xF000F0);
        double roll = rotationTime > 0.0f ? 360.0 * (double)((float)world.m_46467_() % rotationTime / rotationTime) : 0.0;
        double pitch = Math.toDegrees(Math.atan2(combinedVec.f_82480_, Math.sqrt(combinedVec.f_82479_ * combinedVec.f_82479_ + combinedVec.f_82481_ * combinedVec.f_82481_)));
        double yaw = Math.toDegrees(Math.atan2(-combinedVec.f_82481_, combinedVec.f_82479_)) - 90.0;
        float length = (float)combinedVec.m_82553_();
        PoseStack matrixStack = new PoseStack();
        matrixStack.m_85836_();
        matrixStack.m_85837_(firstX - cam.f_82479_, firstY - cam.f_82480_, firstZ - cam.f_82481_);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_((float)yaw));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_((float)pitch));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_((float)roll));
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172832_);
        Tesselator.m_85913_().m_85915_().m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85816_);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(FORGE_WHITE);
        float minU = sprite.m_118409_();
        float maxU = sprite.m_118410_();
        float minV = sprite.m_118411_();
        float maxV = sprite.m_118412_();
        for (int i = 1; i < 4; ++i) {
            float width = beamWidth * ((float)i / 4.0f);
            builder.m_252986_(matrix, -width, width, 0.0f).m_85950_(r, g, b, a).m_7421_(minU, maxV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, width, width, 0.0f).m_85950_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, width, width, -length).m_85950_(r, g, b, a).m_7421_(maxU, minV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, -width, width, -length).m_85950_(r, g, b, a).m_7421_(minU, minV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, -width, -width, 0.0f).m_85950_(r, g, b, a).m_7421_(minU, maxV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, -width, -width, -length).m_85950_(r, g, b, a).m_7421_(minU, minV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, width, -width, -length).m_85950_(r, g, b, a).m_7421_(maxU, minV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, width, -width, 0.0f).m_85950_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, -width, width, 0.0f).m_85950_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, -width, -width, 0.0f).m_85950_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, -width, -width, -length).m_85950_(r, g, b, a).m_7421_(minU, minV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, -width, width, -length).m_85950_(r, g, b, a).m_7421_(minU, minV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, width, width, 0.0f).m_85950_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, width, -width, 0.0f).m_85950_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, width, -width, -length).m_85950_(r, g, b, a).m_7421_(minU, minV).m_85969_(lightmap).m_5752_();
            builder.m_252986_(matrix, width, width, -length).m_85950_(r, g, b, a).m_7421_(minU, minV).m_85969_(lightmap).m_5752_();
        }
        matrixStack.m_85849_();
        Tesselator.m_85913_().m_85914_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderTextInWorld(GuiGraphics guiGraphics, double offsetX, double offsetY, double offsetZ, NonNullList<String> text, int color) {
        PoseStack matrices = guiGraphics.m_280168_();
        matrices.m_85836_();
        matrices.m_85837_(offsetX, offsetY, offsetZ);
        matrices.m_85841_(-1.0f, -1.0f, 1.0f);
        matrices.m_252781_(Axis.f_252436_.m_252977_(Minecraft.m_91087_().f_91075_.m_146908_()));
        matrices.m_85841_(0.01f, 0.01f, 0.01f);
        Font font = Minecraft.m_91087_().f_91062_;
        int y = 0;
        for (String s : text) {
            guiGraphics.m_280488_(font, s, 0, y, color);
            y += 10;
        }
        matrices.m_85849_();
    }

    public static float[] getWheelColor(float pos) {
        if (pos < 85.0f) {
            return new float[]{pos * 3.0f, 255.0f - pos * 3.0f, 0.0f};
        }
        if (pos < 170.0f) {
            return new float[]{255.0f - (pos -= 85.0f) * 3.0f, 0.0f, pos * 3.0f};
        }
        return new float[]{0.0f, (pos -= 170.0f) * 3.0f, 255.0f - pos * 3.0f};
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderHitOutline(PoseStack poseStack, VertexConsumer consumer, Entity entity, double camX, double camY, double camZ, Level level, BlockPos pos, BlockState state) {
        AssetUtil.renderShape(poseStack, consumer, state.m_60651_((BlockGetter)level, pos, CollisionContext.m_82750_((Entity)entity)), (double)pos.m_123341_() - camX, (double)pos.m_123342_() - camY, (double)pos.m_123343_() - camZ, 0.0f, 0.0f, 0.0f, 0.4f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderShape(PoseStack poseStack, VertexConsumer consumer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        shape.m_83224_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            float f = (float)(maxX - minX);
            float f1 = (float)(maxY - minY);
            float f2 = (float)(maxZ - minZ);
            float f3 = Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
            consumer.m_252986_(posestack$pose.m_252922_(), (float)(minX + x), (float)(minY + y), (float)(minZ + z)).m_85950_(red, green, blue, alpha).m_252939_(posestack$pose.m_252943_(), f /= f3, f1 /= f3, f2 /= f3).m_5752_();
            consumer.m_252986_(posestack$pose.m_252922_(), (float)(maxX + x), (float)(maxY + y), (float)(maxZ + z)).m_85950_(red, green, blue, alpha).m_252939_(posestack$pose.m_252943_(), f, f1, f2).m_5752_();
        });
    }
}

