/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerRangedCollector;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TileEntityRangedCollector
extends TileEntityInventoryBase
implements IButtonReactor,
MenuProvider {
    public static final int RANGE = 6;
    public FilterSettings filter = new FilterSettings(12, true, false, false, false);

    public TileEntityRangedCollector(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.RANGED_COLLECTOR.getTileEntityType(), pos, state, 6);
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.filter.writeToNBT(compound, "Filter");
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.filter.readFromNBT(compound, "Filter");
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        List items = this.f_58857_.m_45976_(ItemEntity.class, new AABB((double)(this.f_58858_.m_123341_() - 6), (double)(this.f_58858_.m_123342_() - 6), (double)(this.f_58858_.m_123343_() - 6), (double)(this.f_58858_.m_123341_() + 6), (double)(this.f_58858_.m_123342_() + 6), (double)(this.f_58858_.m_123343_() + 6)));
        if (!items.isEmpty()) {
            for (ItemEntity item : items) {
                ItemStack toAdd;
                if (!item.m_6084_() || item.m_32063_() || item.m_32055_().m_41619_() || !this.filter.check(toAdd = item.m_32055_().m_41777_())) continue;
                ArrayList<ItemStack> checkList = new ArrayList<ItemStack>();
                checkList.add(toAdd);
                if (!StackUtil.canAddAll(this.inv, checkList, false)) continue;
                StackUtil.addAll(this.inv, checkList, false);
                ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123796_, item.m_20185_(), item.m_20186_() + (double)0.45f, item.m_20189_(), 5, 0.0, 0.0, 0.0, 0.03);
                item.m_146870_();
            }
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityRangedCollector) {
            TileEntityRangedCollector tile = (TileEntityRangedCollector)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityRangedCollector) {
            TileEntityRangedCollector tile = (TileEntityRangedCollector)t;
            tile.serverTick();
            if (!tile.isRedstonePowered && !tile.isPulseMode) {
                tile.activateOnPulse();
            }
            if (tile.filter.needsUpdateSend() && tile.sendUpdateWithInterval()) {
                tile.filter.updateLasts();
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation;
    }

    @Override
    public void onButtonPressed(int buttonID, Player player) {
        this.filter.onButtonPressed(buttonID);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.actuallyadditions.rangedCollector");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, @Nonnull Inventory playerInventory, @Nonnull Player player) {
        return new ContainerRangedCollector(windowId, playerInventory, this);
    }
}

