/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.SingleItem;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerFurnaceDouble;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityPoweredFurnace
extends TileEntityInventoryBase
implements IButtonReactor,
MenuProvider {
    public static final int SLOT_INPUT_1 = 0;
    public static final int SLOT_OUTPUT_1 = 1;
    public static final int SLOT_INPUT_2 = 2;
    public static final int SLOT_OUTPUT_2 = 3;
    public static final int ENERGY_USE = 25;
    private static final int SMELT_TIME = 80;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(30000, 150, 0);
    public final LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.storage);
    public int firstSmeltTime;
    public int secondSmeltTime;
    public boolean isAutoSplit;
    private int lastEnergy;
    private int lastFirstSmelt;
    private int lastSecondSmelt;
    private boolean lastAutoSplit;
    private boolean lastSmelted;

    public TileEntityPoweredFurnace(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.POWERED_FURNACE.getTileEntityType(), pos, state, 4);
    }

    public static void autoSplit(ItemStackHandlerAA inv, int slot1, int slot2) {
        ItemStack first = inv.getStackInSlot(slot1);
        ItemStack second = inv.getStackInSlot(slot2);
        if (!first.m_41619_() || !second.m_41619_()) {
            ItemStack toSplit = ItemStack.f_41583_;
            if (first.m_41619_() && !second.m_41619_() && second.m_41613_() > 1) {
                toSplit = second;
            } else if (second.m_41619_() && !first.m_41619_() && first.m_41613_() > 1) {
                toSplit = first;
            } else if (!(!ItemUtil.canBeStacked(first, second) || first.m_41613_() >= first.m_41741_() && second.m_41613_() >= second.m_41741_() || first.m_41613_() <= second.m_41613_() + 1 && first.m_41613_() >= second.m_41613_() - 1 || second.m_41613_() <= first.m_41613_() + 1 && second.m_41613_() >= first.m_41613_() - 1)) {
                toSplit = first;
                toSplit.m_41769_(second.m_41613_());
            }
            if (!toSplit.m_41619_()) {
                ItemStack splitFirst = toSplit.m_41777_();
                ItemStack secondSplit = splitFirst.m_41620_(splitFirst.m_41613_() / 2);
                inv.setStackInSlot(slot1, splitFirst);
                inv.setStackInSlot(slot2, secondSplit);
            }
        }
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128405_("FirstSmeltTime", this.firstSmeltTime);
            compound.m_128405_("SecondSmeltTime", this.secondSmeltTime);
            compound.m_128379_("IsAutoSplit", this.isAutoSplit);
        }
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.firstSmeltTime = compound.m_128451_("FirstSmeltTime");
            this.secondSmeltTime = compound.m_128451_("SecondSmeltTime");
            this.isAutoSplit = compound.m_128471_("IsAutoSplit");
        }
        this.storage.readFromNBT(compound);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPoweredFurnace) {
            TileEntityPoweredFurnace tile = (TileEntityPoweredFurnace)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPoweredFurnace) {
            boolean current;
            TileEntityPoweredFurnace tile = (TileEntityPoweredFurnace)t;
            tile.serverTick();
            if (tile.isAutoSplit) {
                TileEntityPoweredFurnace.autoSplit(tile.inv, 0, 2);
            }
            boolean smelted = false;
            boolean canSmeltOnFirst = tile.canSmeltOn(0, 1);
            boolean canSmeltOnSecond = tile.canSmeltOn(2, 3);
            if (canSmeltOnFirst) {
                if (tile.storage.getEnergyStored() >= 25) {
                    ++tile.firstSmeltTime;
                    if (tile.firstSmeltTime >= 80) {
                        tile.finishBurning(0, 1);
                        tile.firstSmeltTime = 0;
                    }
                    tile.storage.extractEnergyInternal(25, false);
                }
                smelted = true;
            } else {
                tile.firstSmeltTime = 0;
            }
            if (canSmeltOnSecond) {
                if (tile.storage.getEnergyStored() >= 25) {
                    ++tile.secondSmeltTime;
                    if (tile.secondSmeltTime >= 80) {
                        tile.finishBurning(2, 3);
                        tile.secondSmeltTime = 0;
                    }
                    tile.storage.extractEnergyInternal(25, false);
                }
                smelted = true;
            } else {
                tile.secondSmeltTime = 0;
            }
            boolean changeTo = current = ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue();
            if (tile.lastSmelted != smelted) {
                changeTo = smelted;
            }
            if (tile.isRedstonePowered) {
                changeTo = true;
            }
            if (!smelted && !tile.isRedstonePowered) {
                changeTo = false;
            }
            if (changeTo != current) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(changeTo)), 3);
            }
            tile.lastSmelted = smelted;
            if ((tile.lastEnergy != tile.storage.getEnergyStored() || tile.lastFirstSmelt != tile.firstSmeltTime || tile.lastSecondSmelt != tile.secondSmeltTime || tile.isAutoSplit != tile.lastAutoSplit) && tile.sendUpdateWithInterval()) {
                tile.lastEnergy = tile.storage.getEnergyStored();
                tile.lastFirstSmelt = tile.firstSmeltTime;
                tile.lastAutoSplit = tile.isAutoSplit;
                tile.lastSecondSmelt = tile.secondSmeltTime;
            }
        }
    }

    public boolean validInput(ItemStack stack) {
        return this.getOutputForInput(stack).isPresent();
    }

    public Optional<ItemStack> getOutputForInput(ItemStack stack) {
        return this.f_58857_.m_7654_().m_129894_().m_44015_(RecipeType.f_44108_, (Container)new SingleItem(stack), this.f_58857_).map(recipe -> recipe.m_8043_(this.f_58857_.m_9598_()));
    }

    public Optional<SmeltingRecipe> getRecipeForInput(ItemStack stack) {
        return this.f_58857_.m_7654_().m_129894_().m_44015_(RecipeType.f_44108_, (Container)new SingleItem(stack), this.f_58857_);
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || (slot == 0 || slot == 2) && this.validInput(stack);
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation || slot == 1 || slot == 3;
    }

    public boolean canSmeltOn(int theInput, int theOutput) {
        ItemStack input = this.inv.getStackInSlot(theInput);
        ItemStack output = this.inv.getStackInSlot(theOutput);
        if (!input.m_41619_()) {
            Optional<SmeltingRecipe> recipe = this.getRecipeForInput(input);
            return recipe.map($ -> output.m_41619_() || ItemStack.m_41656_((ItemStack)output, (ItemStack)$.m_8043_(this.f_58857_.m_9598_())) && output.m_41613_() <= output.m_41741_() - $.m_8043_(this.f_58857_.m_9598_()).m_41613_()).orElse(false);
        }
        return false;
    }

    public void finishBurning(int theInput, int theOutput) {
        ItemStack output = this.getOutputForInput(this.inv.getStackInSlot(theInput)).orElse(ItemStack.f_41583_);
        if (this.inv.getStackInSlot(theOutput).m_41619_()) {
            this.inv.setStackInSlot(theOutput, output.m_41777_());
        } else if (this.inv.getStackInSlot(theOutput).m_41720_() == output.m_41720_()) {
            this.inv.getStackInSlot(theOutput).m_41769_(output.m_41613_());
        }
        this.inv.getStackInSlot(theInput).m_41774_(1);
    }

    public int getFirstTimeToScale(int i) {
        return this.firstSmeltTime * i / 80;
    }

    public int getSecondTimeToScale(int i) {
        return this.secondSmeltTime * i / 80;
    }

    @Override
    public void onButtonPressed(int buttonID, Player player) {
        if (buttonID == 0) {
            this.isAutoSplit = !this.isAutoSplit;
            this.m_6596_();
        }
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyStorage(Direction facing) {
        return this.lazyEnergy;
    }

    @Nonnull
    public Component m_5446_() {
        return Component.m_237115_((String)"container.actuallyadditions.powered_furnace");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, @Nonnull Inventory playerInventory, @Nonnull Player player) {
        return new ContainerFurnaceDouble(windowId, playerInventory, this);
    }
}

