/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public class TileEntityPlayerInterface
extends TileEntityBase
implements IEnergyDisplay {
    public static final int DEFAULT_RANGE = 32;
    private final CustomEnergyStorage storage = new CustomEnergyStorage(30000, 50, 0);
    public final LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.storage);
    public UUID connectedPlayer;
    public String playerName;
    private IItemHandler playerHandler;
    private Player oldPlayer;
    private int oldEnergy;
    private int range;

    public TileEntityPlayerInterface(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.PLAYER_INTERFACE.getTileEntityType(), pos, state);
    }

    private Player getPlayer() {
        Player player;
        if (this.connectedPlayer != null && this.f_58857_ != null && (player = this.f_58857_.m_46003_(this.connectedPlayer)) != null && player.m_20275_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()) <= (double)this.range) {
            return player;
        }
        return null;
    }

    @Override
    public LazyOptional<IItemHandler> getItemHandler(Direction facing) {
        Player player = this.getPlayer();
        if (this.oldPlayer != player) {
            this.oldPlayer = player;
            this.playerHandler = player == null ? null : new PlayerInvWrapper(player.m_150109_());
        }
        return this.playerHandler == null ? LazyOptional.empty() : LazyOptional.of(() -> this.playerHandler);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPlayerInterface) {
            TileEntityPlayerInterface tile = (TileEntityPlayerInterface)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPlayerInterface) {
            TileEntityPlayerInterface tile = (TileEntityPlayerInterface)t;
            tile.serverTick();
            boolean changed = false;
            tile.range = TileEntityPhantomface.upgradeRange(32, level, pos);
            Player player = tile.getPlayer();
            if (player != null) {
                for (int i = 0; i < player.m_150109_().m_6643_() && tile.storage.getEnergyStored() > 0; ++i) {
                    int received;
                    ItemStack slot = player.m_150109_().m_8020_(i);
                    if (slot.m_41619_() || slot.m_41613_() != 1 || (received = slot.getCapability(ForgeCapabilities.ENERGY).map(cap -> cap.receiveEnergy(tile.storage.getEnergyStored(), false)).orElse(0).intValue()) <= 0) continue;
                    tile.storage.extractEnergyInternal(received, false);
                }
            }
            if (changed) {
                tile.m_6596_();
                tile.sendUpdate();
            }
            if (tile.storage.getEnergyStored() != tile.oldEnergy && tile.sendUpdateWithInterval()) {
                tile.oldEnergy = tile.storage.getEnergyStored();
            }
        }
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (this.connectedPlayer != null && type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128362_("Player", this.connectedPlayer);
            compound.m_128359_("PlayerName", this.playerName);
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (compound.m_128441_("Player") && type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.connectedPlayer = compound.m_128342_("Player");
            this.playerName = compound.m_128461_("PlayerName");
        }
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyStorage(Direction facing) {
        return this.lazyEnergy;
    }
}

