/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.BlockPhantom;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class TileEntityPhantomface
extends TileEntityInventoryBase
implements IPhantomTile {
    public static final int RANGE = 16;
    public BlockPos boundPosition;
    public BlockPhantom.Type type;
    public int range;
    private int rangeBefore;
    private BlockPos boundPosBefore;
    private Block boundBlockBefore;
    private int lastStrength;

    public TileEntityPhantomface(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 0);
    }

    public static int upgradeRange(int defaultRange, Level world, BlockPos pos) {
        Block block;
        int newRange = defaultRange;
        for (int i = 0; i < 3 && (block = world.m_8055_(pos.m_6630_(1 + i)).m_60734_()) == ActuallyBlocks.PHANTOM_BOOSTER.get(); ++i) {
            newRange *= 2;
        }
        return newRange;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128405_("Range", this.range);
            if (this.boundPosition != null) {
                compound.m_128405_("xOfTileStored", this.boundPosition.m_123341_());
                compound.m_128405_("yOfTileStored", this.boundPosition.m_123342_());
                compound.m_128405_("zOfTileStored", this.boundPosition.m_123343_());
            }
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            int x = compound.m_128451_("xOfTileStored");
            int y = compound.m_128451_("yOfTileStored");
            int z = compound.m_128451_("zOfTileStored");
            this.range = compound.m_128451_("Range");
            if (x != 0 || y != 0 || z != 0) {
                this.boundPosition = new BlockPos(x, y, z);
                this.m_6596_();
            }
        }
    }

    @Override
    protected void serverTick() {
        int strength;
        super.serverTick();
        this.range = TileEntityPhantomface.upgradeRange(16, this.f_58857_, this.m_58899_());
        if (!this.hasBoundPosition()) {
            this.boundPosition = null;
        }
        if (this.doesNeedUpdateSend()) {
            this.onUpdateSent();
        }
        if (this.lastStrength != (strength = this.getComparatorStrength())) {
            this.lastStrength = strength;
            this.m_6596_();
        }
    }

    @Override
    protected void clientTick() {
        super.clientTick();
        if (this.boundPosition != null) {
            this.renderParticles();
        }
    }

    protected boolean doesNeedUpdateSend() {
        return this.boundPosition != this.boundPosBefore || this.boundPosition != null && this.f_58857_.m_8055_(this.boundPosition).m_60734_() != this.boundBlockBefore || this.rangeBefore != this.range;
    }

    protected void onUpdateSent() {
        this.rangeBefore = this.range;
        this.boundPosBefore = this.boundPosition;
        Block block = this.boundBlockBefore = this.boundPosition == null ? null : this.f_58857_.m_8055_(this.boundPosition).m_60734_();
        if (this.boundPosition != null) {
            this.f_58857_.m_46672_(this.f_58858_, this.f_58857_.m_8055_(this.boundPosition).m_60734_());
        }
        this.sendUpdate();
        this.m_6596_();
    }

    @Override
    public boolean hasBoundPosition() {
        if (this.boundPosition != null) {
            if (this.f_58857_.m_7702_(this.boundPosition) instanceof IPhantomTile || this.m_58899_().m_123341_() == this.boundPosition.m_123341_() && this.m_58899_().m_123342_() == this.boundPosition.m_123342_() && this.m_58899_().m_123343_() == this.boundPosition.m_123343_()) {
                this.boundPosition = null;
                return false;
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderParticles() {
        if (this.f_58857_.f_46441_.m_188503_(2) == 0) {
            double d1 = (float)this.boundPosition.m_123342_() + this.f_58857_.f_46441_.m_188501_();
            int i1 = this.f_58857_.f_46441_.m_188503_(2) * 2 - 1;
            int j1 = this.f_58857_.f_46441_.m_188503_(2) * 2 - 1;
            double d4 = ((double)this.f_58857_.f_46441_.m_188501_() - 0.5) * 0.125;
            double d2 = (double)this.boundPosition.m_123343_() + 0.5 + 0.25 * (double)j1;
            double d5 = this.f_58857_.f_46441_.m_188501_() * 1.0f * (float)j1;
            double d0 = (double)this.boundPosition.m_123341_() + 0.5 + 0.25 * (double)i1;
            double d3 = this.f_58857_.f_46441_.m_188501_() * 1.0f * (float)i1;
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0, d1, d2, d3, d4, d5);
        }
    }

    @Override
    public boolean isBoundThingInRange() {
        return this.hasBoundPosition() && this.boundPosition.m_123331_((Vec3i)this.m_58899_()) <= (double)(this.range * this.range);
    }

    @Override
    public BlockPos getBoundPosition() {
        return this.boundPosition;
    }

    @Override
    public void setBoundPosition(BlockPos pos) {
        this.boundPosition = pos;
    }

    public int getGuiID() {
        return -1;
    }

    @Override
    public int getRange() {
        return this.range;
    }

    protected abstract boolean isCapabilitySupported(Capability<?> var1);

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        BlockEntity tile;
        if (this.isBoundThingInRange() && this.isCapabilitySupported(capability) && (tile = this.f_58857_.m_7702_(this.getBoundPosition())) != null) {
            return tile.getCapability(capability, side);
        }
        return LazyOptional.empty();
    }

    @Override
    public int getComparatorStrength() {
        BlockPos pos;
        BlockState state;
        if (this.isBoundThingInRange() && (state = this.f_58857_.m_8055_(pos = this.getBoundPosition())).m_60807_()) {
            return state.m_60674_(this.f_58857_, pos);
        }
        return 0;
    }
}

