/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityPhantomRedstoneface
extends TileEntityPhantomface {
    public final int[] providesStrong = new int[Direction.values().length];
    public final int[] providesWeak = new int[Direction.values().length];
    private final int[] lastProvidesStrong = new int[this.providesStrong.length];
    private final int[] lastProvidesWeak = new int[this.providesWeak.length];

    public TileEntityPhantomRedstoneface(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.PHANTOM_REDSTONEFACE.getTileEntityType(), pos, state);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPhantomRedstoneface) {
            TileEntityPhantomRedstoneface tile = (TileEntityPhantomRedstoneface)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPhantomRedstoneface) {
            Block boundBlock;
            BlockState boundState;
            TileEntityPhantomRedstoneface tile = (TileEntityPhantomRedstoneface)t;
            tile.serverTick();
            if (tile.isBoundThingInRange() && (boundState = tile.f_58857_.m_8055_(tile.boundPosition)) != null && (boundBlock = boundState.m_60734_()) != null) {
                for (int i = 0; i < Direction.values().length; ++i) {
                    Direction facing = Direction.values()[i];
                    tile.providesWeak[i] = boundState.m_60746_((BlockGetter)tile.f_58857_, tile.boundPosition, facing);
                    tile.providesStrong[i] = boundState.m_60775_((BlockGetter)tile.f_58857_, tile.boundPosition, facing);
                }
            }
        }
    }

    @Override
    protected boolean doesNeedUpdateSend() {
        return super.doesNeedUpdateSend() || !Arrays.equals(this.providesStrong, this.lastProvidesStrong) || !Arrays.equals(this.providesWeak, this.lastProvidesWeak);
    }

    @Override
    protected void onUpdateSent() {
        System.arraycopy(this.providesWeak, 0, this.lastProvidesWeak, 0, this.providesWeak.length);
        System.arraycopy(this.providesStrong, 0, this.lastProvidesStrong, 0, this.providesStrong.length);
        super.onUpdateSent();
    }

    @Override
    protected boolean isCapabilitySupported(Capability<?> capability) {
        return false;
    }
}

