/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerPhantomPlacer;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;

public class TileEntityPhantomPlacer
extends TileEntityInventoryBase
implements IPhantomTile,
IButtonReactor,
MenuProvider {
    public static final int RANGE = 3;
    public BlockPos boundPosition;
    public int currentTime;
    public int range;
    public boolean isBreaker;
    public int side;
    private int oldRange;

    public TileEntityPhantomPlacer(BlockEntityType<?> type, BlockPos pos, BlockState state, int slots) {
        super(type, pos, state, slots);
    }

    public TileEntityPhantomPlacer(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.PHANTOM_PLACER.getTileEntityType(), pos, state, 9);
        this.isBreaker = false;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128405_("Range", this.range);
            if (this.boundPosition != null) {
                compound.m_128405_("xOfTileStored", this.boundPosition.m_123341_());
                compound.m_128405_("yOfTileStored", this.boundPosition.m_123342_());
                compound.m_128405_("zOfTileStored", this.boundPosition.m_123343_());
            }
            if (!this.isBreaker) {
                compound.m_128405_("Side", this.side);
            }
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            int x = compound.m_128451_("xOfTileStored");
            int y = compound.m_128451_("yOfTileStored");
            int z = compound.m_128451_("zOfTileStored");
            this.range = compound.m_128451_("Range");
            if (x != 0 || y != 0 || z != 0) {
                this.boundPosition = new BlockPos(x, y, z);
                this.m_6596_();
            }
            if (!this.isBreaker) {
                this.side = compound.m_128451_("Side");
            }
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPhantomPlacer) {
            TileEntityPhantomPlacer tile = (TileEntityPhantomPlacer)t;
            tile.clientTick();
            if (tile.boundPosition != null) {
                tile.renderParticles();
            }
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPhantomPlacer) {
            TileEntityPhantomPlacer tile = (TileEntityPhantomPlacer)t;
            tile.serverTick();
            tile.range = TileEntityPhantomface.upgradeRange(3, tile.f_58857_, tile.f_58858_);
            if (!tile.hasBoundPosition()) {
                tile.boundPosition = null;
            }
            if (tile.isBoundThingInRange() && !tile.isRedstonePowered && !tile.isPulseMode) {
                if (tile.currentTime > 0) {
                    --tile.currentTime;
                    if (tile.currentTime <= 0) {
                        tile.doWork();
                    }
                } else {
                    tile.currentTime = 30;
                }
            }
            if (tile.oldRange != tile.range) {
                tile.oldRange = tile.range;
                tile.sendUpdate();
            }
        }
    }

    @Override
    public boolean hasBoundPosition() {
        if (this.boundPosition != null) {
            if (this.f_58857_.m_7702_(this.boundPosition) instanceof IPhantomTile || this.m_58899_().m_123341_() == this.boundPosition.m_123341_() && this.m_58899_().m_123342_() == this.boundPosition.m_123342_() && this.m_58899_().m_123343_() == this.boundPosition.m_123343_() && this.f_58857_.m_6042_() == this.f_58857_.m_6042_()) {
                this.boundPosition = null;
                return false;
            }
            return this.f_58857_.m_6042_() == this.f_58857_.m_6042_();
        }
        return false;
    }

    private void doWork() {
        if (this.isBoundThingInRange()) {
            if (this.isBreaker) {
                List drops;
                Block blockToBreak = this.f_58857_.m_8055_(this.boundPosition).m_60734_();
                if (blockToBreak != null && this.f_58857_.m_8055_(this.boundPosition).m_60800_((BlockGetter)this.f_58857_, this.boundPosition) > -1.0f && StackUtil.canAddAll(this.inv, drops = Block.m_49869_((BlockState)this.f_58857_.m_8055_(this.boundPosition), (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)this.f_58858_, (BlockEntity)this.f_58857_.m_7702_(this.f_58858_)), false)) {
                    this.f_58857_.m_46796_(2001, this.boundPosition, Block.m_49956_((BlockState)this.f_58857_.m_8055_(this.boundPosition)));
                    this.f_58857_.m_46597_(this.boundPosition, Blocks.f_50016_.m_49966_());
                    StackUtil.addAll(this.inv, drops, false);
                    this.m_6596_();
                }
            } else {
                int theSlot = StackUtil.findFirstFilled((IItemHandler)this.inv);
                if (theSlot == -1) {
                    return;
                }
                this.inv.setStackInSlot(theSlot, WorldUtil.useItemAtSide(WorldUtil.getDirectionBySidesInOrder(this.side), this.f_58857_, this.boundPosition, this.inv.getStackInSlot(theSlot)));
            }
        }
    }

    public void renderParticles() {
        if (this.f_58857_.f_46441_.m_188503_(2) == 0) {
            double d1 = (float)this.boundPosition.m_123342_() + this.f_58857_.f_46441_.m_188501_();
            int i1 = this.f_58857_.f_46441_.m_188503_(2) * 2 - 1;
            int j1 = this.f_58857_.f_46441_.m_188503_(2) * 2 - 1;
            double d4 = ((double)this.f_58857_.f_46441_.m_188501_() - 0.5) * 0.125;
            double d2 = (double)this.boundPosition.m_123343_() + 0.5 + 0.25 * (double)j1;
            double d5 = this.f_58857_.f_46441_.m_188501_() * 1.0f * (float)j1;
            double d0 = (double)this.boundPosition.m_123341_() + 0.5 + 0.25 * (double)i1;
            double d3 = this.f_58857_.f_46441_.m_188501_() * 1.0f * (float)i1;
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0, d1, d2, d3, d4, d5);
        }
    }

    @Override
    public boolean isBoundThingInRange() {
        return this.hasBoundPosition() && this.boundPosition.m_123331_((Vec3i)this.f_58858_) <= (double)(this.range * this.range);
    }

    @Override
    public BlockPos getBoundPosition() {
        return this.boundPosition;
    }

    @Override
    public void setBoundPosition(BlockPos pos) {
        this.boundPosition = pos;
    }

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return ItemStackHandlerAA.ACCEPT_TRUE;
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation;
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    @Override
    public void onButtonPressed(int buttonID, Player player) {
        this.side = this.side + 1 >= Direction.values().length ? 0 : ++this.side;
        this.sendUpdate();
    }

    @Nonnull
    public Component m_5446_() {
        return Component.m_237115_((String)"container.actuallyadditions.phantomPlacer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new ContainerPhantomPlacer(windowId, playerInventory, this);
    }
}

