/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.BlockPhantom;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayFluids;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class TileEntityPhantomLiquiface
extends TileEntityPhantomface
implements ISharingFluidHandler {
    public TileEntityPhantomLiquiface(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.PHANTOM_LIQUIFACE.getTileEntityType(), pos, state);
        this.type = BlockPhantom.Type.LIQUIFACE;
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPhantomLiquiface) {
            TileEntityPhantomLiquiface tile = (TileEntityPhantomLiquiface)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPhantomLiquiface) {
            TileEntityPhantomLiquiface tile = (TileEntityPhantomLiquiface)t;
            tile.serverTick();
        }
    }

    @Override
    public boolean isBoundThingInRange() {
        BlockEntity tile;
        if (super.isBoundThingInRange() && (tile = this.f_58857_.m_7702_(this.boundPosition)) != null && !(tile instanceof TileEntityLaserRelayFluids)) {
            for (Direction facing : Direction.values()) {
                if (!tile.getCapability(ForgeCapabilities.FLUID_HANDLER, facing).isPresent()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isCapabilitySupported(Capability<?> capability) {
        return capability == ForgeCapabilities.FLUID_HANDLER;
    }

    @Override
    public int getMaxFluidAmountToSplitShare() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean doesShareFluid() {
        return true;
    }

    @Override
    public Direction[] getFluidShareSides() {
        return Direction.values();
    }
}

