/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.BlockPhantom;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class TileEntityPhantomItemface
extends TileEntityPhantomface {
    public TileEntityPhantomItemface(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.PHANTOM_ITEMFACE.getTileEntityType(), pos, state);
        this.type = BlockPhantom.Type.ITEMFACE;
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPhantomItemface) {
            TileEntityPhantomItemface tile = (TileEntityPhantomItemface)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPhantomItemface) {
            TileEntityPhantomItemface tile = (TileEntityPhantomItemface)t;
            tile.serverTick();
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || this.isBoundThingInRange();
    }

    @Override
    public boolean isBoundThingInRange() {
        BlockEntity tile;
        if (super.isBoundThingInRange() && (tile = this.f_58857_.m_7702_(this.getBoundPosition())) != null) {
            for (Direction facing : Direction.values()) {
                if (!tile.getCapability(ForgeCapabilities.ITEM_HANDLER, facing).isPresent()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isCapabilitySupported(Capability<?> capability) {
        return capability == ForgeCapabilities.ITEM_HANDLER;
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation || this.isBoundThingInRange();
    }
}

