/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.BlockPhantom;
import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergy;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class TileEntityPhantomEnergyface
extends TileEntityPhantomface
implements ISharingEnergyProvider {
    public TileEntityPhantomEnergyface(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.PHANTOM_ENERGYFACE.getTileEntityType(), pos, state);
        this.type = BlockPhantom.Type.ENERGYFACE;
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPhantomEnergyface) {
            TileEntityPhantomEnergyface tile = (TileEntityPhantomEnergyface)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPhantomEnergyface) {
            TileEntityPhantomEnergyface tile = (TileEntityPhantomEnergyface)t;
            tile.serverTick();
        }
    }

    @Override
    public boolean isBoundThingInRange() {
        BlockEntity tile;
        if (super.isBoundThingInRange() && (tile = this.f_58857_.m_7702_(this.boundPosition)) != null && !(tile instanceof TileEntityLaserRelayEnergy)) {
            for (Direction facing : Direction.values()) {
                if (!tile.getCapability(ForgeCapabilities.ENERGY, facing).isPresent()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isCapabilitySupported(Capability<?> capability) {
        return capability == ForgeCapabilities.ENERGY;
    }

    @Override
    public int getEnergyToSplitShare() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean doesShareEnergy() {
        return true;
    }

    @Override
    public Direction[] getEnergyShareSides() {
        return Direction.values();
    }

    @Override
    public boolean canShareTo(BlockEntity tile) {
        return true;
    }
}

