/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.crafting.LiquidFuelRecipe;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerOilGenerator;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TileEntityOilGenerator
extends TileEntityBase
implements ISharingEnergyProvider,
ISharingFluidHandler,
MenuProvider {
    public final CustomEnergyStorage storage = new CustomEnergyStorage(50000, 0, (Integer)CommonConfig.Machines.OIL_GENERATOR_TRANSFER.get());
    public final LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.storage);
    public final FluidTank tank = new FluidTank(2000, fluid -> TileEntityOilGenerator.getRecipeForFluid(fluid) != null){

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    };
    public final LazyOptional<IFluidHandler> lazyTank = LazyOptional.of(() -> this.tank);
    public int currentEnergyProduce;
    public int currentBurnTime;
    public int maxBurnTime;
    private int lastEnergy;
    private int lastTank;
    private int lastBurnTime;
    private int lastMaxBurnTime;
    private int lastEnergyProduce;
    private int lastCompare;
    public int fuelUsage;

    public TileEntityOilGenerator(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.OIL_GENERATOR.getTileEntityType(), pos, state);
    }

    private static LiquidFuelRecipe getRecipeForFluid(FluidStack fluid) {
        return ActuallyAdditions.getRecipeManager().m_44013_((RecipeType)ActuallyRecipes.Types.LIQUID_FUEL.get()).stream().filter(x -> x.matches(fluid)).findFirst().orElse(null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBurningScaled(int i) {
        return this.currentBurnTime * i / this.maxBurnTime;
    }

    private LiquidFuelRecipe getRecipeForCurrentFluid() {
        FluidStack stack = this.tank.getFluid();
        if (!stack.isEmpty()) {
            return TileEntityOilGenerator.getRecipeForFluid(stack);
        }
        return null;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128405_("BurnTime", this.currentBurnTime);
            compound.m_128405_("CurrentEnergy", this.currentEnergyProduce);
            compound.m_128405_("MaxBurnTime", this.maxBurnTime);
            compound.m_128405_("FuelUsage", this.fuelUsage);
        }
        this.storage.writeToNBT(compound);
        this.tank.writeToNBT(compound);
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentBurnTime = compound.m_128451_("BurnTime");
            this.currentEnergyProduce = compound.m_128451_("CurrentEnergy");
            this.maxBurnTime = compound.m_128451_("MaxBurnTime");
            this.fuelUsage = compound.m_128451_("FuelUsage");
        }
        this.storage.readFromNBT(compound);
        this.tank.readFromNBT(compound);
        super.readSyncableNBT(compound, type);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityOilGenerator) {
            TileEntityOilGenerator tile = (TileEntityOilGenerator)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityOilGenerator) {
            boolean flag;
            TileEntityOilGenerator tile = (TileEntityOilGenerator)t;
            tile.serverTick();
            boolean bl = flag = tile.currentBurnTime > 0;
            if (tile.currentBurnTime > 0 && tile.currentEnergyProduce > 0) {
                --tile.currentBurnTime;
                tile.storage.receiveEnergyInternal(tile.currentEnergyProduce, false);
            } else if (!tile.isRedstonePowered) {
                LiquidFuelRecipe recipe = tile.getRecipeForCurrentFluid();
                if (recipe != null && tile.storage.getEnergyStored() < tile.storage.getMaxEnergyStored() && tile.tank.getFluidAmount() >= recipe.getFuelAmount()) {
                    tile.fuelUsage = recipe.getFuelAmount();
                    tile.currentEnergyProduce = recipe.getTotalEnergy() / recipe.getBurnTime();
                    tile.currentBurnTime = tile.maxBurnTime = recipe.getBurnTime();
                    tile.tank.getFluid().shrink(tile.fuelUsage);
                } else {
                    tile.currentEnergyProduce = 0;
                    tile.currentBurnTime = 0;
                    tile.maxBurnTime = 0;
                    tile.fuelUsage = 0;
                }
            }
            if (flag != tile.currentBurnTime > 0 || tile.lastCompare != tile.getComparatorStrength()) {
                tile.lastCompare = tile.getComparatorStrength();
                tile.m_6596_();
            }
            if ((tile.storage.getEnergyStored() != tile.lastEnergy || tile.tank.getFluidAmount() != tile.lastTank || tile.lastBurnTime != tile.currentBurnTime || tile.lastEnergyProduce != tile.currentEnergyProduce || tile.lastMaxBurnTime != tile.maxBurnTime) && tile.sendUpdateWithInterval()) {
                tile.lastEnergy = tile.storage.getEnergyStored();
                tile.lastTank = tile.tank.getFluidAmount();
                tile.lastBurnTime = tile.currentBurnTime;
                tile.lastEnergyProduce = tile.currentEnergyProduce;
                tile.lastMaxBurnTime = tile.maxBurnTime;
            }
        }
    }

    @Override
    public int getComparatorStrength() {
        float calc = (float)this.storage.getEnergyStored() / (float)this.storage.getMaxEnergyStored() * 15.0f;
        return (int)calc;
    }

    @Override
    public LazyOptional<IFluidHandler> getFluidHandler(Direction facing) {
        return this.lazyTank;
    }

    @Override
    public int getMaxFluidAmountToSplitShare() {
        return 0;
    }

    @Override
    public boolean doesShareFluid() {
        return false;
    }

    @Override
    public Direction[] getFluidShareSides() {
        return null;
    }

    @Override
    public int getEnergyToSplitShare() {
        return this.storage.getEnergyStored();
    }

    @Override
    public boolean doesShareEnergy() {
        return true;
    }

    @Override
    public Direction[] getEnergyShareSides() {
        return Direction.values();
    }

    @Override
    public boolean canShareTo(BlockEntity tile) {
        return true;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyStorage(Direction facing) {
        return this.lazyEnergy;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.actuallyadditions.oilGenerator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new ContainerOilGenerator(windowId, playerInventory, this);
    }
}

