/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerDirectionalBreaker;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityLongRangeBreaker
extends TileEntityInventoryBase
implements MenuProvider {
    public static final int RANGE = 8;
    public static final int ENERGY_USE = 5;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(10000, 20, 0);
    public final LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.storage);
    private int lastEnergy;
    private int currentTime;

    public TileEntityLongRangeBreaker(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.LONG_RANGE_BREAKER.getTileEntityType(), pos, state, 9);
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128405_("CurrentTime", this.currentTime);
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentTime = compound.m_128451_("CurrentTime");
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLongRangeBreaker) {
            TileEntityLongRangeBreaker tile = (TileEntityLongRangeBreaker)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLongRangeBreaker) {
            TileEntityLongRangeBreaker tile = (TileEntityLongRangeBreaker)t;
            tile.serverTick();
            if (!tile.isRedstonePowered && !tile.isPulseMode) {
                if (tile.currentTime > 0) {
                    --tile.currentTime;
                    if (tile.currentTime <= 0) {
                        tile.doWork();
                    }
                } else {
                    tile.currentTime = 15;
                }
            }
            if (tile.storage.getEnergyStored() != tile.lastEnergy && tile.sendUpdateWithInterval()) {
                tile.lastEnergy = tile.storage.getEnergyStored();
            }
        }
    }

    private void doWork() {
        if (this.storage.getEnergyStored() >= 40) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            Direction sideToManipulate = WorldUtil.getDirectionByPistonRotation(state);
            for (int i = 0; i < 8; ++i) {
                List drops;
                float chance;
                BlockPos coordsBlock = this.f_58858_.m_5484_(sideToManipulate, i + 1);
                BlockState breakState = this.f_58857_.m_8055_(coordsBlock);
                Block blockToBreak = breakState.m_60734_();
                if (blockToBreak == null || this.f_58857_.m_46859_(coordsBlock) || !(this.f_58857_.m_8055_(coordsBlock).m_60800_((BlockGetter)this.f_58857_, coordsBlock) > -1.0f) || !((chance = WorldUtil.fireFakeHarvestEventsForDropChance(this, drops = Block.m_49869_((BlockState)breakState, (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)coordsBlock, (BlockEntity)this.f_58857_.m_7702_(coordsBlock)), this.f_58857_, coordsBlock)) > 0.0f) || !(this.f_58857_.f_46441_.m_188501_() <= chance) || !StackUtil.canAddAll(this.inv, drops, false)) continue;
                this.f_58857_.m_46796_(2001, coordsBlock, Block.m_49956_((BlockState)this.f_58857_.m_8055_(coordsBlock)));
                this.f_58857_.m_46597_(coordsBlock, Blocks.f_50016_.m_49966_());
                StackUtil.addAll(this.inv, drops, false);
                this.storage.extractEnergyInternal(5, false);
                this.m_6596_();
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation;
    }

    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyStorage(Direction facing) {
        return this.lazyEnergy;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.actuallyadditions.directionalBreaker");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
        return new ContainerDirectionalBreaker(windowId, playerInventory, this);
    }
}

