/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityLeafGenerator
extends TileEntityBase
implements ISharingEnergyProvider,
IEnergyDisplay {
    public final CustomEnergyStorage storage = new CustomEnergyStorage(35000, 0, 450);
    public final LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.storage);
    private int nextUseCounter;
    private int oldEnergy;

    public TileEntityLeafGenerator(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.LEAF_GENERATOR.getTileEntityType(), pos, state);
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLeafGenerator) {
            TileEntityLeafGenerator tile = (TileEntityLeafGenerator)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLeafGenerator) {
            TileEntityLeafGenerator tile = (TileEntityLeafGenerator)t;
            tile.serverTick();
            if (!tile.isRedstonePowered) {
                if (tile.nextUseCounter >= (Integer)CommonConfig.Machines.LEAF_GENERATOR_COOLDOWN.get()) {
                    tile.nextUseCounter = 0;
                    int energyProduced = (Integer)CommonConfig.Machines.LEAF_GENERATOR_CF_PER_LEAF.get();
                    if (energyProduced > 0 && energyProduced <= tile.storage.getMaxEnergyStored() - tile.storage.getEnergyStored()) {
                        int range = (Integer)CommonConfig.Machines.LEAF_GENERATOR_AREA.get();
                        List breakPositions = BlockPos.m_121990_((BlockPos)pos.m_7918_(-range, -range, -range), (BlockPos)pos.m_7918_(range, range, range)).map(BlockPos::m_7949_).collect(Collectors.toList());
                        breakPositions.removeIf(blockPos -> {
                            BlockState offsetState = level.m_8055_(blockPos);
                            return !(offsetState.m_60734_() instanceof LeavesBlock) && !offsetState.m_204336_(BlockTags.f_13035_);
                        });
                        if (!breakPositions.isEmpty()) {
                            Collections.shuffle(breakPositions);
                            BlockPos theCoord = (BlockPos)breakPositions.get(0);
                            level.m_46796_(2001, theCoord, Block.m_49956_((BlockState)level.m_8055_(theCoord)));
                            level.m_46597_(theCoord, Blocks.f_50016_.m_49966_());
                            tile.storage.receiveEnergyInternal(energyProduced, false);
                            AssetUtil.spawnLaserWithTimeServer(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), theCoord.m_123341_(), theCoord.m_123342_(), theCoord.m_123343_(), 4105034, 25, 0.0, 0.075f, 0.8f);
                        }
                    }
                } else {
                    ++tile.nextUseCounter;
                }
            }
            if (tile.oldEnergy != tile.storage.getEnergyStored() && tile.sendUpdateWithInterval()) {
                tile.oldEnergy = tile.storage.getEnergyStored();
            }
        }
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public int getEnergyToSplitShare() {
        return this.storage.getEnergyStored();
    }

    @Override
    public boolean doesShareEnergy() {
        return true;
    }

    @Override
    public Direction[] getEnergyShareSides() {
        return Direction.values();
    }

    @Override
    public boolean canShareTo(BlockEntity tile) {
        return true;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyStorage(Direction facing) {
        return this.lazyEnergy;
    }
}

