/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityLavaFactoryController
extends TileEntityBase
implements IEnergyDisplay {
    public static final int NOT_MULTI = 0;
    public static final int HAS_LAVA = 1;
    public static final int HAS_AIR = 2;
    public static final int ENERGY_USE = 150000;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(300000, 2000, 0);
    public final LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.storage);
    private int currentWorkTime;
    private int oldEnergy;

    public TileEntityLavaFactoryController(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.LAVA_FACTORY_CONTROLLER.getTileEntityType(), pos, state);
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128405_("WorkTime", this.currentWorkTime);
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentWorkTime = compound.m_128451_("WorkTime");
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLavaFactoryController) {
            TileEntityLavaFactoryController tile = (TileEntityLavaFactoryController)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLavaFactoryController) {
            TileEntityLavaFactoryController tile = (TileEntityLavaFactoryController)t;
            tile.serverTick();
            if (tile.storage.getEnergyStored() >= 150000 && tile.isMultiblock() == 2) {
                ++tile.currentWorkTime;
                if (tile.currentWorkTime >= 200) {
                    tile.currentWorkTime = 0;
                    level.m_7731_(tile.f_58858_.m_7494_(), Blocks.f_49991_.m_49966_(), 2);
                    tile.storage.extractEnergyInternal(150000, false);
                }
            } else {
                tile.currentWorkTime = 0;
            }
            if (tile.oldEnergy != tile.storage.getEnergyStored() && tile.sendUpdateWithInterval()) {
                tile.oldEnergy = tile.storage.getEnergyStored();
            }
        }
    }

    public int isMultiblock() {
        BlockPos thisPos = this.f_58858_;
        BlockPos[] positions = new BlockPos[]{thisPos.m_7918_(1, 1, 0), thisPos.m_7918_(-1, 1, 0), thisPos.m_7918_(0, 1, 1), thisPos.m_7918_(0, 1, -1)};
        if (this.f_58857_ != null && WorldUtil.hasBlocksInPlacesGiven(positions, ActuallyBlocks.LAVA_FACTORY_CASING.get(), this.f_58857_)) {
            BlockPos pos = thisPos.m_7494_();
            BlockState state = this.f_58857_.m_8055_(pos);
            Block block = state.m_60734_();
            if (block == Blocks.f_49991_) {
                return 1;
            }
            if (this.f_58857_.m_46859_(pos)) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyStorage(Direction facing) {
        return this.lazyEnergy;
    }
}

