/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityItemInterface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.SlotlessableItemHandlerWrapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntityLaserRelayItem
extends TileEntityLaserRelay {
    public final Map<BlockPos, SlotlessableItemHandlerWrapper> handlersAround = new ConcurrentHashMap<BlockPos, SlotlessableItemHandlerWrapper>();
    public int priority;

    public TileEntityLaserRelayItem(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, LaserType.ITEM);
    }

    public TileEntityLaserRelayItem(BlockPos pos, BlockState state) {
        this(ActuallyBlocks.LASER_RELAY_ITEM.getTileEntityType(), pos, state);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLaserRelayItem) {
            TileEntityLaserRelayItem tile = (TileEntityLaserRelayItem)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLaserRelayItem) {
            TileEntityLaserRelayItem tile = (TileEntityLaserRelayItem)t;
            tile.serverTick();
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isWhitelisted(ItemStack stack, boolean output) {
        return true;
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        Network network;
        HashMap<BlockPos, SlotlessableItemHandlerWrapper> old = new HashMap<BlockPos, SlotlessableItemHandlerWrapper>(this.handlersAround);
        boolean change = false;
        this.handlersAround.clear();
        for (int i = 0; i <= 5; ++i) {
            BlockEntity tile;
            Direction side = WorldUtil.getDirectionBySidesInOrder(i);
            BlockPos pos = this.m_58899_().m_121945_(side);
            if (!this.f_58857_.m_46805_(pos) || (tile = this.f_58857_.m_7702_(pos)) == null || tile instanceof TileEntityItemInterface || tile instanceof TileEntityLaserRelay) continue;
            LazyOptional itemHandler = tile.getCapability(ForgeCapabilities.ITEM_HANDLER, side.m_122424_());
            Object slotlessHandler = null;
            SlotlessableItemHandlerWrapper handler = new SlotlessableItemHandlerWrapper((LazyOptional<IItemHandler>)itemHandler, slotlessHandler);
            this.handlersAround.put(pos, handler);
            SlotlessableItemHandlerWrapper oldHandler = (SlotlessableItemHandlerWrapper)old.get(pos);
            if (handler.equals(oldHandler)) continue;
            change = true;
        }
        if ((change || old.size() != this.handlersAround.size()) && (network = this.getNetwork()) != null) {
            ++network.changeAmount;
        }
    }

    public void getItemHandlersInNetwork(Network network, List<TileEntityItemInterface.GenericItemHandlerInfo> storeList) {
        HashSet<BlockPos> alreadyChecked = new HashSet<BlockPos>();
        for (IConnectionPair pair : network.connections) {
            for (BlockPos relay : pair.getPositions()) {
                if (relay == null || !this.f_58857_.m_46805_(relay) || alreadyChecked.contains(relay)) continue;
                alreadyChecked.add(relay);
                BlockEntity aRelayTile = this.f_58857_.m_7702_(relay);
                if (!(aRelayTile instanceof TileEntityLaserRelayItem)) continue;
                TileEntityLaserRelayItem relayTile = (TileEntityLaserRelayItem)aRelayTile;
                TileEntityItemInterface.GenericItemHandlerInfo info = new TileEntityItemInterface.GenericItemHandlerInfo(relayTile);
                for (Map.Entry<BlockPos, SlotlessableItemHandlerWrapper> handler : relayTile.handlersAround.entrySet()) {
                    if (alreadyChecked.contains(handler.getKey())) continue;
                    alreadyChecked.add(handler.getKey());
                    info.handlers.add(handler.getValue());
                }
                storeList.add(info);
            }
        }
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128405_("Priority", this.priority);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getExtraDisplayString() {
        return Component.m_237115_((String)"info.actuallyadditions.laserRelay.item.extra").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)String.valueOf(this.getPriority())).m_130940_(ChatFormatting.DARK_RED));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getCompassDisplayString() {
        return Component.m_237115_((String)"info.actuallyadditions.laserRelay.item.display.1").m_130946_(" - ").m_7220_((Component)Component.m_237115_((String)"info.actuallyadditions.laserRelay.item.display.2")).m_130940_(ChatFormatting.GREEN);
    }

    @Override
    public void onCompassAction(Player player) {
        this.priority = player.m_6047_() ? --this.priority : ++this.priority;
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.priority = compound.m_128451_("Priority");
        }
    }
}

