/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergy;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityLaserRelayFluids
extends TileEntityLaserRelay {
    public final ConcurrentHashMap<Direction, BlockEntity> handlersAround = new ConcurrentHashMap();
    private final IFluidHandler[] fluidHandlers = new IFluidHandler[6];
    private TileEntityLaserRelayEnergy.Mode mode = TileEntityLaserRelayEnergy.Mode.BOTH;

    public TileEntityLaserRelayFluids(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.LASER_RELAY_FLUIDS.getTileEntityType(), pos, state, LaserType.FLUID);
        for (int i = 0; i < this.fluidHandlers.length; ++i) {
            final Direction facing = Direction.values()[i];
            this.fluidHandlers[i] = new IFluidHandler(){

                public int getTanks() {
                    return 0;
                }

                @Nonnull
                public FluidStack getFluidInTank(int tank) {
                    return FluidStack.EMPTY;
                }

                public int getTankCapacity(int tank) {
                    return 0;
                }

                public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                    return false;
                }

                public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                    return TileEntityLaserRelayFluids.this.transmitFluid(facing, resource, action);
                }

                @Nonnull
                public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                    return FluidStack.EMPTY;
                }

                @Nonnull
                public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                    return FluidStack.EMPTY;
                }
            };
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLaserRelayFluids) {
            TileEntityLaserRelayFluids tile = (TileEntityLaserRelayFluids)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLaserRelayFluids) {
            TileEntityLaserRelayFluids tile = (TileEntityLaserRelayFluids)t;
            tile.serverTick();
        }
    }

    @Override
    protected void serverTick() {
        super.serverTick();
        if (this.mode == TileEntityLaserRelayEnergy.Mode.INPUT_ONLY) {
            for (Direction side : this.handlersAround.keySet()) {
                WorldUtil.doFluidInteraction(this.handlersAround.get(side), this, side.m_122424_(), Integer.MAX_VALUE);
            }
        }
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        Network network;
        HashMap<Direction, BlockEntity> old = new HashMap<Direction, BlockEntity>(this.handlersAround);
        boolean change = false;
        this.handlersAround.clear();
        for (Direction side : Direction.values()) {
            BlockEntity tile;
            BlockPos pos = this.m_58899_().m_121945_(side);
            if (!this.f_58857_.m_46805_(pos) || (tile = this.f_58857_.m_7702_(pos)) == null || tile instanceof TileEntityLaserRelay || !tile.getCapability(ForgeCapabilities.FLUID_HANDLER, side.m_122424_()).isPresent()) continue;
            this.handlersAround.put(side, tile);
            BlockEntity oldTile = (BlockEntity)old.get(side);
            if (oldTile != null && tile.equals(oldTile)) continue;
            change = true;
        }
        if ((change || old.size() != this.handlersAround.size()) && (network = this.getNetwork()) != null) {
            ++network.changeAmount;
        }
    }

    @Override
    public LazyOptional<IFluidHandler> getFluidHandler(Direction facing) {
        return LazyOptional.of(() -> this.fluidHandlers[facing == null ? 0 : facing.ordinal()]);
    }

    private int transmitFluid(Direction from, FluidStack stack, IFluidHandler.FluidAction action) {
        Network network;
        int transmitted = 0;
        if (stack != null && this.mode != TileEntityLaserRelayEnergy.Mode.OUTPUT_ONLY && (network = this.getNetwork()) != null) {
            transmitted = this.transferFluidToReceiverInNeed(from, network, stack, action);
        }
        return transmitted;
    }

    private int transferFluidToReceiverInNeed(Direction from, Network network, FluidStack stack, IFluidHandler.FluidAction action) {
        int transmitted = 0;
        HashSet<BlockPos> alreadyChecked = new HashSet<BlockPos>();
        HashSet<TileEntityLaserRelayFluids> relaysThatWork = new HashSet<TileEntityLaserRelayFluids>();
        int totalReceiverAmount = 0;
        for (IConnectionPair pair : network.connections) {
            for (BlockPos relay : pair.getPositions()) {
                if (relay == null || !this.f_58857_.m_46805_(relay) || alreadyChecked.contains(relay)) continue;
                alreadyChecked.add(relay);
                BlockEntity relayTile = this.f_58857_.m_7702_(relay);
                if (!(relayTile instanceof TileEntityLaserRelayFluids)) continue;
                TileEntityLaserRelayFluids theRelay = (TileEntityLaserRelayFluids)relayTile;
                if (theRelay.mode == TileEntityLaserRelayEnergy.Mode.INPUT_ONLY) continue;
                boolean workedOnce = false;
                for (Direction facing : theRelay.handlersAround.keySet()) {
                    Direction opp;
                    BlockEntity tile;
                    boolean received;
                    if (theRelay == this && facing == from || !(received = (tile = theRelay.handlersAround.get(facing)).getCapability(ForgeCapabilities.FLUID_HANDLER, opp = facing.m_122424_()).map(cap -> cap.fill(stack, IFluidHandler.FluidAction.SIMULATE) > 0).orElse(false).booleanValue())) continue;
                    ++totalReceiverAmount;
                    workedOnce = true;
                }
                if (!workedOnce) continue;
                relaysThatWork.add(theRelay);
            }
        }
        if (totalReceiverAmount > 0 && !relaysThatWork.isEmpty()) {
            int amountPer = stack.getAmount() / totalReceiverAmount > 0 ? stack.getAmount() / totalReceiverAmount : stack.getAmount();
            for (TileEntityLaserRelayFluids theRelay : relaysThatWork) {
                for (Map.Entry<Direction, BlockEntity> receiver : theRelay.handlersAround.entrySet()) {
                    if (receiver == null) continue;
                    Direction side = receiver.getKey();
                    Direction opp = side.m_122424_();
                    BlockEntity tile = receiver.getValue();
                    if (alreadyChecked.contains(tile.m_58899_())) continue;
                    alreadyChecked.add(tile.m_58899_());
                    if (theRelay == this && side == from || (transmitted += tile.getCapability(ForgeCapabilities.FLUID_HANDLER, opp).map(cap -> {
                        int trans = 0;
                        FluidStack copy = stack.copy();
                        copy.setAmount(amountPer);
                        return trans += cap.fill(copy, action);
                    }).orElse(0).intValue()) < stack.getAmount()) continue;
                    return transmitted;
                }
            }
        }
        return transmitted;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getExtraDisplayString() {
        return Component.m_237115_((String)"info.actuallyadditions.laserRelay.fluid.extra").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)this.mode.name).m_130940_(ChatFormatting.DARK_RED));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getCompassDisplayString() {
        return Component.m_237115_((String)"info.actuallyadditions.laserRelay.energy.display").m_130940_(ChatFormatting.GREEN);
    }

    @Override
    public void onCompassAction(Player player) {
        this.mode = this.mode.getNext();
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128359_("Mode", this.mode.toString());
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        String modeStrg;
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK && (modeStrg = compound.m_128461_("Mode")) != null && !modeStrg.isEmpty()) {
            this.mode = TileEntityLaserRelayEnergy.Mode.valueOf(modeStrg);
        }
    }
}

