/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.ConnectionPair;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import io.netty.util.internal.ConcurrentSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public abstract class TileEntityLaserRelay
extends TileEntityInventoryBase {
    public static final int MAX_DISTANCE = 15;
    public static final int MAX_DISTANCE_RANGED = 35;
    public final LaserType type;
    private Network cachedNetwork;
    private int changeAmountAtCaching = -1;
    private int lastRange;
    private final ConcurrentSet<IConnectionPair> connections = new ConcurrentSet();

    public TileEntityLaserRelay(BlockEntityType<?> tileType, BlockPos pos, BlockState state, LaserType type) {
        super(tileType, pos, state, 1);
        this.type = type;
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SYNC) {
            ActuallyAdditionsAPI.connectionHandler.removeRelayFromNetwork(this.f_58858_, this.f_58857_);
            this.connections.clear();
            ListTag list = compound.m_128437_("Connections", 10);
            if (!list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    ConnectionPair pair = new ConnectionPair();
                    this.connections.add((Object)pair);
                    pair.readFromNBT(list.m_128728_(i));
                    ActuallyAdditionsAPI.connectionHandler.addConnection(pair.getPositions()[0], pair.getPositions()[1], this.type, this.f_58857_, pair.doesSuppressRender());
                }
            }
        }
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SYNC) {
            ListTag list = new ListTag();
            ConcurrentSet<IConnectionPair> connections = ActuallyAdditionsAPI.connectionHandler.getConnectionsFor(this.f_58858_, this.f_58857_);
            if (connections != null && !connections.isEmpty()) {
                for (IConnectionPair pair : connections) {
                    CompoundTag tag = new CompoundTag();
                    pair.writeToNBT(tag);
                    list.add((Object)tag);
                }
            }
            compound.m_128365_("Connections", (Tag)list);
        }
    }

    @Override
    protected void clientTick() {
        super.clientTick();
        int range = this.getMaxRange();
        if (this.lastRange != range) {
            ConcurrentSet<IConnectionPair> connections = ActuallyAdditionsAPI.connectionHandler.getConnectionsFor(this.f_58858_, this.f_58857_);
            if (connections != null && !connections.isEmpty()) {
                for (IConnectionPair pair : connections) {
                    int distanceSq = (int)pair.getPositions()[0].m_123331_((Vec3i)pair.getPositions()[1]);
                    if (distanceSq <= range * range) continue;
                    this.connections.remove((Object)pair);
                    ActuallyAdditionsAPI.connectionHandler.removeConnection(this.f_58857_, pair.getPositions()[0], pair.getPositions()[1]);
                }
            }
            this.lastRange = range;
        }
    }

    @Override
    protected void serverTick() {
        super.serverTick();
        int range = this.getMaxRange();
        if (this.lastRange != range) {
            ConcurrentSet<IConnectionPair> connections = ActuallyAdditionsAPI.connectionHandler.getConnectionsFor(this.f_58858_, this.f_58857_);
            if (connections != null && !connections.isEmpty()) {
                for (IConnectionPair pair : connections) {
                    int distanceSq = (int)pair.getPositions()[0].m_123331_((Vec3i)pair.getPositions()[1]);
                    if (distanceSq <= range * range) continue;
                    this.connections.remove((Object)pair);
                    ActuallyAdditionsAPI.connectionHandler.removeConnection(this.f_58857_, pair.getPositions()[0], pair.getPositions()[1]);
                }
            }
            this.lastRange = range;
        }
    }

    public Network getNetwork() {
        if (this.cachedNetwork == null || this.cachedNetwork.changeAmount != this.changeAmountAtCaching) {
            this.cachedNetwork = ActuallyAdditionsAPI.connectionHandler.getNetworkFor(this.f_58858_, this.f_58857_);
            this.changeAmountAtCaching = this.cachedNetwork != null ? this.cachedNetwork.changeAmount : -1;
        }
        return this.cachedNetwork;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public boolean shouldSyncSlots() {
        return true;
    }

    @Override
    public LazyOptional<IItemHandler> getItemHandler(Direction facing) {
        return LazyOptional.empty();
    }

    public int getMaxRange() {
        ItemStack upgrade = this.inv.getStackInSlot(0);
        if (StackUtil.isValid(upgrade) && upgrade.m_41720_() == ActuallyItems.LASER_UPGRADE_RANGE.get()) {
            return 35;
        }
        return 15;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract Component getExtraDisplayString();

    @OnlyIn(value=Dist.CLIENT)
    public abstract Component getCompassDisplayString();

    public abstract void onCompassAction(Player var1);

    public ConcurrentSet<IConnectionPair> getConnections() {
        return this.connections;
    }
}

