/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityItemInterface;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.SlotlessableItemHandlerWrapper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntityItemInterfaceHopping
extends TileEntityItemInterface {
    private SlotlessableItemHandlerWrapper handlerToPullFrom;
    private SlotlessableItemHandlerWrapper handlerToPushTo;

    public TileEntityItemInterfaceHopping(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.ITEM_INTERFACE_HOPPING.getTileEntityType(), pos, state);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityItemInterfaceHopping) {
            TileEntityItemInterfaceHopping tile = (TileEntityItemInterfaceHopping)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityItemInterfaceHopping) {
            TileEntityItemInterfaceHopping tile = (TileEntityItemInterfaceHopping)t;
            tile.serverTick();
            if (level.m_6106_().m_6793_() % 10L == 0L) {
                AABB axisAlignedBB;
                List items;
                if (tile.handlerToPullFrom != null) {
                    WorldUtil.doItemInteraction(tile.handlerToPullFrom, tile.itemHandler, 4);
                } else if (level.m_6106_().m_6793_() % 20L == 0L && (items = level.m_142425_((EntityTypeTest)EntityType.f_20461_, axisAlignedBB = new AABB((double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 2), (double)(pos.m_123343_() + 1)), EntitySelector.f_20402_)) != null && !items.isEmpty()) {
                    for (ItemEntity item : items) {
                        if (item == null) continue;
                        if (ActuallyAdditions.commonCapsLoaded) {
                            Object object = tile.itemHandler.getSlotlessHandler();
                        }
                        LazyOptional<IItemHandler> handler = tile.itemHandler.getNormalHandler();
                        handler.ifPresent(cap -> {
                            System.out.println(cap.getSlots());
                            for (int i = 0; i < cap.getSlots(); ++i) {
                                ItemStack left = cap.insertItem(i, item.m_32055_(), false);
                                item.m_32045_(left);
                                if (!left.m_41619_()) continue;
                                item.m_146870_();
                                break;
                            }
                        });
                    }
                }
                if (tile.handlerToPushTo != null) {
                    WorldUtil.doItemInteraction(tile.itemHandler, tile.handlerToPushTo, 4);
                }
            }
        }
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        BlockEntity to;
        super.saveDataOnChangeOrWorldStart();
        this.handlerToPullFrom = null;
        this.handlerToPushTo = null;
        BlockEntity from = this.f_58857_.m_7702_(this.m_58899_().m_121945_(Direction.UP));
        if (from != null && !(from instanceof TileEntityItemInterface)) {
            LazyOptional normal = from.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN);
            Object slotless = null;
            this.handlerToPullFrom = new SlotlessableItemHandlerWrapper((LazyOptional<IItemHandler>)normal, slotless);
        }
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61373_);
        BlockPos toPos = this.m_58899_().m_121945_(facing);
        if (this.f_58857_.m_46749_(toPos) && (to = this.f_58857_.m_7702_(toPos)) != null && !(to instanceof TileEntityItemInterface)) {
            LazyOptional normal = to.getCapability(ForgeCapabilities.ITEM_HANDLER, facing.m_122424_());
            Object slotless = null;
            this.handlerToPushTo = new SlotlessableItemHandlerWrapper((LazyOptional<IItemHandler>)normal, slotless);
        }
    }
}

