/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketServerToClient;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItem;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.SlotlessableItemHandlerWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntityItemInterface
extends TileEntityBase {
    public final List<GenericItemHandlerInfo> genericInfos = new ArrayList<GenericItemHandlerInfo>();
    public final Map<Integer, IItemHandlerInfo> itemHandlerInfos = new HashMap<Integer, IItemHandlerInfo>();
    public final List<SlotlessItemHandlerInfo> slotlessInfos = new ArrayList<SlotlessItemHandlerInfo>();
    protected final SlotlessableItemHandlerWrapper itemHandler;
    private final LazyOptional<IItemHandler> lazyHandlers;
    public TileEntityLaserRelayItem connectedRelay;
    private int lastNetworkChangeAmount = -1;
    private int slotCount;

    public TileEntityItemInterface(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        IItemHandler normalHandler = new IItemHandler(){

            public int getSlots() {
                return TileEntityItemInterface.this.getSlotCount();
            }

            public ItemStack getStackInSlot(int slot) {
                IItemHandlerInfo handler = TileEntityItemInterface.this.getSwitchedIndexHandler(slot);
                if (handler != null && handler.isLoaded()) {
                    return handler.handler.getStackInSlot(handler.switchedIndex);
                }
                return ItemStack.f_41583_;
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                IItemHandlerInfo info = TileEntityItemInterface.this.getSwitchedIndexHandler(slot);
                if (info != null && info.isLoaded() && TileEntityItemInterface.this.isWhitelisted(info, stack, false)) {
                    ItemStack remain = info.handler.insertItem(info.switchedIndex, stack, simulate);
                    if (!ItemStack.m_41656_((ItemStack)remain, (ItemStack)stack) && !simulate) {
                        TileEntityItemInterface.this.m_6596_();
                        TileEntityItemInterface.this.doItemParticle(stack, info.relayInQuestion.m_58899_(), TileEntityItemInterface.this.connectedRelay.m_58899_());
                    }
                    return remain;
                }
                return stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                IItemHandlerInfo info;
                ItemStack stackIn = this.getStackInSlot(slot);
                if (StackUtil.isValid(stackIn) && (info = TileEntityItemInterface.this.getSwitchedIndexHandler(slot)) != null && info.isLoaded() && TileEntityItemInterface.this.isWhitelisted(info, stackIn, true)) {
                    ItemStack extracted = info.handler.extractItem(info.switchedIndex, amount, simulate);
                    if (StackUtil.isValid(extracted) && !simulate) {
                        TileEntityItemInterface.this.m_6596_();
                        TileEntityItemInterface.this.doItemParticle(extracted, TileEntityItemInterface.this.connectedRelay.m_58899_(), info.relayInQuestion.m_58899_());
                    }
                    return extracted;
                }
                return ItemStack.f_41583_;
            }

            public int getSlotLimit(int slot) {
                IItemHandlerInfo info = TileEntityItemInterface.this.getSwitchedIndexHandler(slot);
                if (info != null && info.isLoaded()) {
                    return info.handler.getSlotLimit(info.switchedIndex);
                }
                return 0;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }
        };
        Object slotlessHandler = null;
        this.lazyHandlers = LazyOptional.of(() -> normalHandler);
        this.itemHandler = new SlotlessableItemHandlerWrapper(this.lazyHandlers, slotlessHandler);
    }

    public TileEntityItemInterface(BlockPos pos, BlockState state) {
        this(ActuallyBlocks.ITEM_INTERFACE.getTileEntityType(), pos, state);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityItemInterface) {
            TileEntityItemInterface tile = (TileEntityItemInterface)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityItemInterface) {
            TileEntityItemInterface tile = (TileEntityItemInterface)t;
            tile.serverTick();
        }
    }

    @Override
    public LazyOptional<IItemHandler> getItemHandler(Direction facing) {
        return this.itemHandler.getNormalHandler();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        return super.getCapability(capability, side);
    }

    private int getSlotCount() {
        this.queryAndSaveData();
        return this.slotCount;
    }

    public void doItemParticle(ItemStack stack, BlockPos input, BlockPos output) {
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = new CompoundTag();
            stack.m_41739_(compound);
            compound.m_128347_("InX", (double)input.m_123341_());
            compound.m_128347_("InY", (double)input.m_123342_());
            compound.m_128347_("InZ", (double)input.m_123343_());
            compound.m_128347_("OutX", (double)output.m_123341_());
            compound.m_128347_("OutY", (double)output.m_123342_());
            compound.m_128347_("OutZ", (double)output.m_123343_());
            int rangeSq = 256;
            for (Player player : this.f_58857_.m_6907_()) {
                if (!(player instanceof ServerPlayer) || !(player.m_20275_((double)input.m_123341_(), (double)input.m_123342_(), (double)input.m_123343_()) <= (double)rangeSq) && !(player.m_20275_((double)output.m_123341_(), (double)output.m_123342_(), (double)output.m_123343_()) <= (double)rangeSq)) continue;
                PacketHandler.sendTo(new PacketServerToClient(compound, PacketHandler.LASER_PARTICLE_HANDLER), (ServerPlayer)player);
            }
        }
    }

    private void queryAndSaveData() {
        Network network;
        if (this.connectedRelay != null && (network = this.connectedRelay.getNetwork()) != null) {
            if (this.lastNetworkChangeAmount != network.changeAmount) {
                this.clearInfos();
                this.connectedRelay.getItemHandlersInNetwork(network, this.genericInfos);
                if (!this.genericInfos.isEmpty()) {
                    Collections.sort(this.genericInfos);
                    int slotsQueried = 0;
                    for (GenericItemHandlerInfo info : this.genericInfos) {
                        if (!info.isLoaded()) continue;
                        for (SlotlessableItemHandlerWrapper handler : info.handlers) {
                            LazyOptional<IItemHandler> normalHandler = handler.getNormalHandler();
                            if (!normalHandler.isPresent()) continue;
                            for (int i = 0; i < ((IItemHandler)normalHandler.resolve().get()).getSlots(); ++i) {
                                this.itemHandlerInfos.put(slotsQueried, new IItemHandlerInfo((IItemHandler)normalHandler.resolve().get(), i, info.relayInQuestion));
                                ++slotsQueried;
                            }
                        }
                    }
                    this.slotCount = slotsQueried;
                }
                this.lastNetworkChangeAmount = network.changeAmount;
            }
            return;
        }
        this.clearInfos();
        this.lastNetworkChangeAmount = -1;
    }

    private void clearInfos() {
        if (!this.genericInfos.isEmpty()) {
            this.genericInfos.clear();
        }
        if (!this.itemHandlerInfos.isEmpty()) {
            this.itemHandlerInfos.clear();
        }
        if (!this.slotlessInfos.isEmpty()) {
            this.slotlessInfos.clear();
        }
    }

    private IItemHandlerInfo getSwitchedIndexHandler(int i) {
        this.queryAndSaveData();
        return this.itemHandlerInfos.get(i);
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        TileEntityLaserRelayItem tileFound = null;
        if (this.f_58857_ != null) {
            for (int i = 0; i <= 5; ++i) {
                BlockEntity tile;
                Direction side = WorldUtil.getDirectionBySidesInOrder(i);
                BlockPos pos = this.m_58899_().m_121945_(side);
                if (!this.f_58857_.m_46749_(pos) || !((tile = this.f_58857_.m_7702_(pos)) instanceof TileEntityLaserRelayItem)) continue;
                if (tileFound != null) {
                    this.connectedRelay = null;
                    return;
                }
                tileFound = (TileEntityLaserRelayItem)tile;
            }
        }
        this.connectedRelay = tileFound;
    }

    public boolean isWhitelisted(SpecificItemHandlerInfo handler, ItemStack stack, boolean output) {
        boolean whitelisted = handler.relayInQuestion.isWhitelisted(stack, output);
        TileEntityLaserRelayItem connected = this.connectedRelay;
        if (connected != null && connected != handler.relayInQuestion) {
            return whitelisted && connected.isWhitelisted(stack, output);
        }
        return whitelisted;
    }

    public static class GenericItemHandlerInfo
    implements Comparable<GenericItemHandlerInfo> {
        public final List<SlotlessableItemHandlerWrapper> handlers = new ArrayList<SlotlessableItemHandlerWrapper>();
        public final TileEntityLaserRelayItem relayInQuestion;

        public GenericItemHandlerInfo(TileEntityLaserRelayItem relayInQuestion) {
            this.relayInQuestion = relayInQuestion;
        }

        public boolean isLoaded() {
            return this.relayInQuestion.m_58898_() && this.relayInQuestion.m_58904_().m_46749_(this.relayInQuestion.m_58899_());
        }

        @Override
        public int compareTo(GenericItemHandlerInfo other) {
            int otherPrio;
            int thisPrio = this.relayInQuestion.getPriority();
            if (thisPrio == (otherPrio = other.relayInQuestion.getPriority())) {
                return 0;
            }
            if (thisPrio > otherPrio) {
                return -1;
            }
            return 1;
        }
    }

    private static class IItemHandlerInfo
    extends SpecificItemHandlerInfo {
        public final IItemHandler handler;
        public final int switchedIndex;

        public IItemHandlerInfo(IItemHandler handler, int switchedIndex, TileEntityLaserRelayItem relayInQuestion) {
            super(relayInQuestion);
            this.handler = handler;
            this.switchedIndex = switchedIndex;
        }
    }

    private static class SpecificItemHandlerInfo {
        public final TileEntityLaserRelayItem relayInQuestion;

        public SpecificItemHandlerInfo(TileEntityLaserRelayItem relayInQuestion) {
            this.relayInQuestion = relayInQuestion;
        }

        public boolean isLoaded() {
            return this.relayInQuestion.m_58898_() && this.relayInQuestion.m_58904_().m_46749_(this.relayInQuestion.m_58899_());
        }
    }

    public static class SlotlessItemHandlerInfo
    extends SpecificItemHandlerInfo {
        public final Object handler;

        public SlotlessItemHandlerInfo(Object handler, TileEntityLaserRelayItem relayInQuestion) {
            super(relayInQuestion);
            this.handler = handler;
        }
    }
}

