/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class TileEntityInventoryBase
extends TileEntityBase {
    public final ItemStackHandlerAA inv;
    public final LazyOptional<IItemHandler> lazyInv;

    public TileEntityInventoryBase(BlockEntityType<?> type, BlockPos pos, BlockState state, int slots) {
        super(type, pos, state);
        this.inv = new TileStackHandler(slots);
        this.lazyInv = LazyOptional.of(() -> this.inv);
    }

    public static void saveSlots(IItemHandler slots, CompoundTag compound) {
        if (slots != null && slots.getSlots() > 0) {
            ListTag tagList = new ListTag();
            for (int i = 0; i < slots.getSlots(); ++i) {
                ItemStack slot = slots.getStackInSlot(i);
                CompoundTag tagCompound = new CompoundTag();
                if (StackUtil.isValid(slot)) {
                    slot.m_41739_(tagCompound);
                }
                tagList.add((Object)tagCompound);
            }
            compound.m_128365_("Items", (Tag)tagList);
        }
    }

    public static void loadSlots(IItemHandlerModifiable slots, CompoundTag compound) {
        if (slots != null && slots.getSlots() > 0) {
            ListTag tagList = compound.m_128437_("Items", 10);
            for (int i = 0; i < slots.getSlots(); ++i) {
                CompoundTag tagCompound = tagList.m_128728_(i);
                slots.setStackInSlot(i, tagCompound.m_128441_("id") ? ItemStack.m_41712_((CompoundTag)tagCompound) : ItemStack.f_41583_);
            }
        }
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE || type == TileEntityBase.NBTType.SYNC && this.shouldSyncSlots()) {
            TileEntityInventoryBase.saveSlots((IItemHandler)this.inv, compound);
        }
    }

    @Override
    public LazyOptional<IItemHandler> getItemHandler(Direction facing) {
        return this.lazyInv;
    }

    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return ItemStackHandlerAA.ACCEPT_TRUE;
    }

    public ItemStackHandlerAA.IRemover getRemover() {
        return ItemStackHandlerAA.REMOVE_TRUE;
    }

    public int getMaxStackSize(int slot) {
        return 64;
    }

    public boolean shouldSyncSlots() {
        return false;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.shouldSyncSlots()) {
            this.sendUpdate();
        }
    }

    @Override
    public int getComparatorStrength() {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.inv);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE || type == TileEntityBase.NBTType.SYNC && this.shouldSyncSlots()) {
            TileEntityInventoryBase.loadSlots((IItemHandlerModifiable)this.inv, compound);
        }
    }

    protected class TileStackHandler
    extends ItemStackHandlerAA {
        protected TileStackHandler(int slots) {
            super(slots);
        }

        @Override
        public ItemStackHandlerAA.IAcceptor getAcceptor() {
            return TileEntityInventoryBase.this.getAcceptor();
        }

        @Override
        public ItemStackHandlerAA.IRemover getRemover() {
            return TileEntityInventoryBase.this.getRemover();
        }

        public int getSlotLimit(int slot) {
            return TileEntityInventoryBase.this.getMaxStackSize(slot);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityInventoryBase.this.m_6596_();
        }
    }
}

