/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityHeatCollector
extends TileEntityBase
implements ISharingEnergyProvider,
IEnergyDisplay {
    public static final int ENERGY_PRODUCE = 40;
    public static final int BLOCKS_NEEDED = 4;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(30000, 0, 80);
    public final LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.storage);
    private int oldEnergy;
    private int disappearTime;

    public TileEntityHeatCollector(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.HEAT_COLLECTOR.getTileEntityType(), pos, state);
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            compound.m_128405_("DisappearTime", this.disappearTime);
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            this.disappearTime = compound.m_128451_("DisappearTime");
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityHeatCollector) {
            TileEntityHeatCollector tile = (TileEntityHeatCollector)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityHeatCollector) {
            TileEntityHeatCollector tile = (TileEntityHeatCollector)t;
            tile.serverTick();
            ArrayList<Integer> blocksAround = new ArrayList<Integer>();
            if (40 <= tile.storage.getMaxEnergyStored() - tile.storage.getEnergyStored()) {
                for (int i = 1; i <= 5; ++i) {
                    BlockPos coords = pos.m_121945_(WorldUtil.getDirectionBySidesInOrder(i));
                    BlockState relativeState = level.m_8055_(coords);
                    Block block = relativeState.m_60734_();
                    if ((block == null || !level.m_6425_(coords).m_205070_(FluidTags.f_13132_)) && !(level.m_8055_(coords).m_60734_() instanceof MagmaBlock)) continue;
                    blocksAround.add(i);
                }
                if (blocksAround.size() >= 4) {
                    tile.storage.receiveEnergyInternal(40, false);
                    tile.m_6596_();
                    ++tile.disappearTime;
                    if (tile.disappearTime >= 1000) {
                        tile.disappearTime = 0;
                        if (level.f_46441_.m_188503_(200) == 0) {
                            int randomSide = (Integer)blocksAround.get(level.f_46441_.m_188503_(blocksAround.size()));
                            level.m_46597_(pos.m_121945_(WorldUtil.getDirectionBySidesInOrder(randomSide)), Blocks.f_50016_.m_49966_());
                        }
                    }
                }
            }
            if (tile.oldEnergy != tile.storage.getEnergyStored() && tile.sendUpdateWithInterval()) {
                tile.oldEnergy = tile.storage.getEnergyStored();
            }
        }
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public int getEnergyToSplitShare() {
        return this.storage.getEnergyStored();
    }

    @Override
    public boolean doesShareEnergy() {
        return true;
    }

    @Override
    public Direction[] getEnergyShareSides() {
        return Direction.values();
    }

    @Override
    public boolean canShareTo(BlockEntity tile) {
        return true;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyStorage(Direction facing) {
        return this.lazyEnergy;
    }
}

