/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.fluids.AATank;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerFluidCollector;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFluidCollector
extends TileEntityBase
implements ISharingFluidHandler,
MenuProvider {
    public boolean isPlacer;
    public final AATank tank = new AATank(8000){

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!TileEntityFluidCollector.this.isPlacer) {
                return 0;
            }
            return super.fill(resource, action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (TileEntityFluidCollector.this.isPlacer) {
                return FluidStack.EMPTY;
            }
            return super.drain(maxDrain, action);
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (TileEntityFluidCollector.this.isPlacer) {
                return FluidStack.EMPTY;
            }
            return super.drain(resource, action);
        }
    };
    public final LazyOptional<IFluidHandler> lazyTank = LazyOptional.of(() -> this.tank);
    private int lastTankAmount;
    private int currentTime;
    private int lastCompare;

    public TileEntityFluidCollector(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileEntityFluidCollector(BlockPos pos, BlockState state) {
        this(ActuallyBlocks.FLUID_COLLECTOR.getTileEntityType(), pos, state);
        this.isPlacer = false;
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    private void doWork() {
        FluidStack stack;
        Block fluid;
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        Direction sideToManipulate = WorldUtil.getDirectionByPistonRotation(state);
        BlockPos coordsBlock = this.f_58858_.m_121945_(sideToManipulate);
        BlockState stateToBreak = this.f_58857_.m_8055_(coordsBlock);
        Block blockToBreak = stateToBreak.m_60734_();
        if (!this.isPlacer && 1000 <= this.tank.getCapacity() - this.tank.getFluidAmount()) {
            if (blockToBreak instanceof LiquidBlock && stateToBreak.m_60819_().m_76170_() && ((LiquidBlock)blockToBreak).getFluid() != null && this.tank.fillInternal(new FluidStack((Fluid)((LiquidBlock)blockToBreak).getFluid(), 1000), IFluidHandler.FluidAction.SIMULATE) >= 1000) {
                this.tank.fillInternal(new FluidStack((Fluid)((LiquidBlock)blockToBreak).getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                this.f_58857_.m_46597_(coordsBlock, Blocks.f_50016_.m_49966_());
            }
        } else if (this.isPlacer && blockToBreak.m_49966_().m_247087_() && this.tank.getFluidAmount() >= 1000 && (fluid = (stack = this.tank.getFluid()).getFluid().m_76145_().m_76188_().m_60734_()) != null) {
            boolean placeable;
            BlockPos offsetPos = this.f_58858_.m_121945_(sideToManipulate);
            boolean bl = placeable = !stateToBreak.m_60819_().m_76170_() && blockToBreak.m_49966_().m_247087_();
            if (placeable) {
                this.tank.drainInternal(1000, IFluidHandler.FluidAction.EXECUTE);
                if (this.f_58857_.m_6042_().f_63857_() && stack.getFluid().m_205067_(FluidTags.f_13131_)) {
                    this.f_58857_.m_5594_(null, offsetPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) * 0.8f);
                    if (this.f_58857_ instanceof ServerLevel) {
                        for (int l = 0; l < 8; ++l) {
                            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)offsetPos.m_123341_() + Math.random(), (double)offsetPos.m_123342_() + Math.random(), (double)offsetPos.m_123343_() + Math.random(), 1, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                } else {
                    this.f_58857_.m_7731_(offsetPos, fluid.m_49966_(), 3);
                }
            }
        }
    }

    @Override
    public int getComparatorStrength() {
        float calc = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity() * 15.0f;
        return (int)calc;
    }

    @Override
    public LazyOptional<IFluidHandler> getFluidHandler(Direction facing) {
        return this.lazyTank;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128405_("CurrentTime", this.currentTime);
        }
        this.tank.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentTime = compound.m_128451_("CurrentTime");
        }
        this.tank.readFromNBT(compound);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFluidCollector) {
            TileEntityFluidCollector tile = (TileEntityFluidCollector)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFluidCollector) {
            TileEntityFluidCollector tile = (TileEntityFluidCollector)t;
            tile.serverTick();
        }
    }

    @Override
    protected void serverTick() {
        super.serverTick();
        if (!this.isRedstonePowered && !this.isPulseMode) {
            if (this.currentTime > 0) {
                --this.currentTime;
                if (this.currentTime <= 0) {
                    this.doWork();
                }
            } else {
                this.currentTime = 15;
            }
        }
        if (this.lastCompare != this.getComparatorStrength()) {
            this.lastCompare = this.getComparatorStrength();
            this.m_6596_();
        }
        if (this.lastTankAmount != this.tank.getFluidAmount() && this.sendUpdateWithInterval()) {
            this.lastTankAmount = this.tank.getFluidAmount();
        }
    }

    @Override
    public int getMaxFluidAmountToSplitShare() {
        return this.tank.getFluidAmount();
    }

    @Override
    public boolean doesShareFluid() {
        return !this.isPlacer;
    }

    @Override
    public Direction[] getFluidShareSides() {
        return Direction.values();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)(this.isPlacer ? "container.actuallyadditions.fluidPlacer" : "container.actuallyadditions.fluidCollector"));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new ContainerFluidCollector(windowId, playerInventory, this);
    }
}

