/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerFireworkBox;
import de.ellpeck.actuallyadditions.mod.network.gui.INumberReactor;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityFireworkBox
extends TileEntityBase
implements IEnergyDisplay,
INumberReactor,
MenuProvider {
    public static final int USE_PER_SHOT = 500;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(20000, 200, 0);
    public final LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.storage);
    public int intValuePlay = 2;
    public int chargeAmount = 2;
    public int flightTime = 2;
    public float trailOrFlickerChance = 0.65f;
    public float flickerChance = 0.25f;
    public int colorAmount = 3;
    public float typeChance0 = 1.0f;
    public float typeChance1 = 0.0f;
    public float typeChance2 = 0.0f;
    public float typeChance3 = 0.0f;
    public float typeChance4 = 0.0f;
    public int areaOfEffect = 2;
    private int timeUntilNextFirework;
    private int oldEnergy;

    public TileEntityFireworkBox(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.FIREWORK_BOX.getTileEntityType(), pos, state);
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128405_("Play", this.intValuePlay);
            compound.m_128405_("ChargeAmount", this.chargeAmount);
            compound.m_128405_("FlightTime", this.flightTime);
            compound.m_128350_("TrailFlickerChance", this.trailOrFlickerChance);
            compound.m_128350_("FlickerChance", this.flickerChance);
            compound.m_128405_("ColorAmount", this.colorAmount);
            compound.m_128350_("TypeChance0", this.typeChance0);
            compound.m_128350_("TypeChance1", this.typeChance1);
            compound.m_128350_("TypeChance2", this.typeChance2);
            compound.m_128350_("TypeChance3", this.typeChance3);
            compound.m_128350_("TypeChance4", this.typeChance4);
            compound.m_128405_("Area", this.areaOfEffect);
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.intValuePlay = compound.m_128451_("Play");
            this.chargeAmount = compound.m_128451_("ChargeAmount");
            this.flightTime = compound.m_128451_("FlightTime");
            this.trailOrFlickerChance = compound.m_128457_("TrailFlickerChance");
            this.flickerChance = compound.m_128457_("FlickerChance");
            this.colorAmount = compound.m_128451_("ColorAmount");
            this.typeChance0 = compound.m_128457_("TypeChance0");
            this.typeChance1 = compound.m_128457_("TypeChance1");
            this.typeChance2 = compound.m_128457_("TypeChance2");
            this.typeChance3 = compound.m_128457_("TypeChance3");
            this.typeChance4 = compound.m_128457_("TypeChance4");
            this.areaOfEffect = compound.m_128451_("Area");
        }
    }

    @Override
    public void onNumberReceived(double number, int id, Player player) {
        switch (id) {
            case 0: {
                this.intValuePlay = (int)number;
                break;
            }
            case 1: {
                this.chargeAmount = (int)number;
                break;
            }
            case 2: {
                this.flightTime = (int)number;
                break;
            }
            case 3: {
                this.trailOrFlickerChance = (float)number;
                break;
            }
            case 4: {
                this.flickerChance = (float)number;
                break;
            }
            case 5: {
                this.colorAmount = (int)number;
                break;
            }
            case 6: {
                this.typeChance0 = (float)number;
                break;
            }
            case 7: {
                this.typeChance1 = (float)number;
                break;
            }
            case 8: {
                this.typeChance2 = (float)number;
                break;
            }
            case 9: {
                this.typeChance3 = (float)number;
                break;
            }
            case 10: {
                this.typeChance4 = (float)number;
                break;
            }
            case 11: {
                this.areaOfEffect = (int)number;
            }
        }
        this.m_6596_();
        this.sendUpdate();
    }

    public void spawnFireworks(Level world, double x, double y, double z) {
        double newZ;
        ItemStack firework = this.makeFirework();
        double newX = x + this.getRandomAoe();
        if (world.m_46805_(BlockPos.m_274561_((double)newX, (double)y, (double)(newZ = z + this.getRandomAoe())))) {
            FireworkRocketEntity rocket = new FireworkRocketEntity(world, newX, y + 1.0, newZ, firework);
            world.m_7967_((Entity)rocket);
        }
    }

    private double getRandomAoe() {
        if (this.areaOfEffect <= 0) {
            return 0.5;
        }
        return Mth.m_216263_((RandomSource)this.f_58857_.f_46441_, (double)0.0, (double)(this.areaOfEffect * 2)) - (double)this.areaOfEffect;
    }

    private ItemStack makeFirework() {
        ListTag list = new ListTag();
        for (int i = 0; i < this.getRandomWithPlay(this.chargeAmount); ++i) {
            list.add((Object)this.makeFireworkCharge());
        }
        CompoundTag compound1 = new CompoundTag();
        compound1.m_128365_("Explosions", (Tag)list);
        compound1.m_128344_("Flight", (byte)this.getRandomWithPlay(this.flightTime));
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("Fireworks", (Tag)compound1);
        ItemStack firework = new ItemStack((ItemLike)Items.f_42688_);
        firework.m_41751_(compound);
        return firework;
    }

    private CompoundTag makeFireworkCharge() {
        CompoundTag compound = new CompoundTag();
        if (this.f_58857_.f_46441_.m_188501_() <= this.trailOrFlickerChance) {
            if (this.f_58857_.f_46441_.m_188501_() <= this.flickerChance) {
                compound.m_128379_("Flicker", true);
            } else {
                compound.m_128379_("Trail", true);
            }
        }
        int[] colors = new int[this.getRandomWithPlay(this.colorAmount)];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = DyeColor.values()[this.f_58857_.f_46441_.m_188503_(DyeColor.values().length)].m_41070_();
        }
        compound.m_128385_("Colors", colors);
        compound.m_128344_("Type", (byte)this.getRandomType());
        return compound;
    }

    private int getRandomWithPlay(int value) {
        return Mth.m_14045_((int)Mth.m_216271_((RandomSource)this.f_58857_.f_46441_, (int)(value - this.intValuePlay), (int)(value + this.intValuePlay)), (int)1, (int)6);
    }

    private int getRandomType() {
        ArrayList<WeightedFireworkType> possible = new ArrayList<WeightedFireworkType>();
        possible.add(new WeightedFireworkType(0, this.typeChance0));
        possible.add(new WeightedFireworkType(1, this.typeChance1));
        possible.add(new WeightedFireworkType(2, this.typeChance2));
        possible.add(new WeightedFireworkType(3, this.typeChance3));
        possible.add(new WeightedFireworkType(4, this.typeChance4));
        int weight = WeightedRandom.m_146312_(possible);
        if (weight <= 0) {
            return 0;
        }
        return WeightedRandom.m_216825_((RandomSource)this.f_58857_.f_46441_, possible, (int)weight).map(weightedFireworkType -> weightedFireworkType.type).orElse(0);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFireworkBox) {
            TileEntityFireworkBox tile = (TileEntityFireworkBox)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFireworkBox) {
            TileEntityFireworkBox tile = (TileEntityFireworkBox)t;
            tile.serverTick();
            if (!tile.isRedstonePowered && !tile.isPulseMode) {
                if (tile.timeUntilNextFirework > 0) {
                    --tile.timeUntilNextFirework;
                    if (tile.timeUntilNextFirework <= 0) {
                        tile.doWork();
                    }
                } else {
                    tile.timeUntilNextFirework = 100;
                }
            }
            if (tile.oldEnergy != tile.storage.getEnergyStored() && tile.sendUpdateWithInterval()) {
                tile.oldEnergy = tile.storage.getEnergyStored();
            }
        }
    }

    private void doWork() {
        if (this.storage.getEnergyStored() >= 500) {
            this.spawnFireworks(this.f_58857_, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
            this.storage.extractEnergyInternal(500, false);
        }
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyStorage(Direction facing) {
        return this.lazyEnergy;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.actuallyadditions.fireworkBox");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player p_createMenu_3_) {
        return new ContainerFireworkBox(windowId, playerInventory, this);
    }

    private static class WeightedFireworkType
    implements WeightedEntry {
        public final int type;
        public final Weight chance;

        public WeightedFireworkType(int type, float chance) {
            this.type = type;
            this.chance = Weight.m_146282_((int)((int)(chance * 100.0f)));
        }

        public Weight m_142631_() {
            return this.chance;
        }
    }
}

