/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.crafting.FermentingRecipe;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerFermentingBarrel;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TileEntityFermentingBarrel
extends TileEntityBase
implements ISharingFluidHandler,
MenuProvider {
    public final FermentingBarrelMultiTank tanks = new FermentingBarrelMultiTank();
    public final LazyOptional<IFluidHandler> fluidOptional = LazyOptional.of(() -> this.tanks);
    public int currentProcessTime;
    private int lastInput;
    private int lastOutput;
    private int lastProcessTime;
    private int lastCompare;
    private FermentingRecipe currentRecipe;

    public TileEntityFermentingBarrel(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.FERMENTING_BARREL.getTileEntityType(), pos, state);
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        compound.m_128405_("ProcessTime", this.currentProcessTime);
        compound.m_128365_("tanks", (Tag)this.tanks.writeNBT());
        if (this.currentRecipe != null) {
            compound.m_128359_("currentRecipe", this.currentRecipe.m_6423_().toString());
        }
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        this.currentProcessTime = compound.m_128451_("ProcessTime");
        if (compound.m_128441_("tanks")) {
            this.tanks.readNBT(compound.m_128469_("tanks"));
        }
        if (compound.m_128441_("currentRecipe")) {
            this.currentRecipe = this.f_58857_.m_7465_().m_44013_((RecipeType)ActuallyRecipes.Types.FERMENTING.get()).stream().filter(recipe -> recipe.m_6423_().toString().equals(compound.m_128461_("currentRecipe"))).findFirst().orElse(null);
        }
        super.readSyncableNBT(compound, type);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFermentingBarrel) {
            TileEntityFermentingBarrel tile = (TileEntityFermentingBarrel)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFermentingBarrel) {
            int compare;
            TileEntityFermentingBarrel tile = (TileEntityFermentingBarrel)t;
            tile.serverTick();
            if (tile.currentRecipe == null) {
                if (tile.ticksElapsed % 20 == 0) {
                    tile.currentRecipe = level.m_7465_().m_44013_((RecipeType)ActuallyRecipes.Types.FERMENTING.get()).stream().filter(recipe -> recipe.matches(tile.tanks.getFluidInTank(0), tile.tanks.getFluidInTank(1))).findFirst().orElse(null);
                }
            } else if (tile.tanks.getFluidInTank(0).getAmount() >= tile.currentRecipe.getInput().getAmount() && tile.tanks.getFluidInTank(0).getFluid().m_6212_(tile.currentRecipe.getInput().getFluid()) && (tile.tanks.getFluidInTank(1).getFluid().m_6212_(tile.currentRecipe.getOutput().getFluid()) || tile.tanks.getFluidInTank(1).isEmpty()) && tile.currentRecipe.getOutput().getAmount() <= tile.tanks.getTankCapacity(1) - tile.tanks.getFluidInTank(1).getAmount()) {
                ++tile.currentProcessTime;
                if (tile.currentProcessTime >= tile.currentRecipe.getTime()) {
                    tile.currentProcessTime = 0;
                    tile.tanks.outputTank.fill(tile.currentRecipe.getOutput().copy(), IFluidHandler.FluidAction.EXECUTE);
                    tile.tanks.inputTank.getFluid().shrink(tile.currentRecipe.getInput().getAmount());
                }
            } else {
                tile.currentProcessTime = 0;
                tile.currentRecipe = null;
            }
            if ((compare = tile.getComparatorStrength()) != tile.lastCompare) {
                tile.lastCompare = compare;
                tile.m_6596_();
            }
            if ((tile.tanks.getFluidInTank(0).getAmount() != tile.lastInput || tile.tanks.getFluidInTank(1).getAmount() != tile.lastOutput || tile.currentProcessTime != tile.lastProcessTime) && tile.sendUpdateWithInterval()) {
                tile.lastProcessTime = tile.currentProcessTime;
                tile.lastInput = tile.tanks.getFluidInTank(0).getAmount();
                tile.lastOutput = tile.tanks.getFluidInTank(1).getAmount();
            }
        }
    }

    @Override
    public int getComparatorStrength() {
        float calc = (float)this.tanks.getFluidInTank(1).getAmount() / (float)this.tanks.getTankCapacity(1) * 15.0f;
        return (int)calc;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProcessScaled(int i) {
        if (this.currentRecipe != null) {
            return this.currentProcessTime * i / this.currentRecipe.getTime();
        }
        return this.currentProcessTime * i / 100;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getOilTankScaled(int i) {
        return this.tanks.getFluidInTank(1).getAmount() * i / this.tanks.getTankCapacity(1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCanolaTankScaled(int i) {
        return this.tanks.getFluidInTank(0).getAmount() * i / this.tanks.getTankCapacity(0);
    }

    @Override
    public LazyOptional<IFluidHandler> getFluidHandler(Direction facing) {
        return this.fluidOptional;
    }

    @Override
    public int getMaxFluidAmountToSplitShare() {
        return this.tanks.getFluidInTank(1).getAmount();
    }

    @Override
    public boolean doesShareFluid() {
        return true;
    }

    @Override
    public Direction[] getFluidShareSides() {
        return Direction.values();
    }

    @Nonnull
    public Component m_5446_() {
        return Component.m_237115_((String)"container.actuallyadditions.fermenting_barrel");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, @Nonnull Inventory playerInventory, @Nonnull Player p_createMenu_3_) {
        return new ContainerFermentingBarrel(windowId, playerInventory, this);
    }

    public static boolean validInput(FluidStack stack) {
        return TileEntityFermentingBarrel.getRecipeForInput(stack).isPresent();
    }

    public static Optional<FermentingRecipe> getRecipeForInput(FluidStack stack) {
        return ActuallyAdditions.getRecipeManager().m_44013_((RecipeType)ActuallyRecipes.Types.FERMENTING.get()).stream().filter(recipe -> recipe.matches(stack)).findFirst();
    }

    public static class FermentingBarrelMultiTank
    implements IFluidHandler {
        private final int capacity = 2000;
        public FluidTank inputTank = new FluidTank(2000);
        public FluidTank outputTank = new FluidTank(2000);

        public int getTanks() {
            return 2;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return tank == 0 ? this.inputTank.getFluid() : this.outputTank.getFluid();
        }

        public int getTankCapacity(int tank) {
            return 2000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return tank == 0 && TileEntityFermentingBarrel.validInput(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || !TileEntityFermentingBarrel.validInput(resource)) {
                return 0;
            }
            if (action.simulate()) {
                if (this.inputTank.isEmpty()) {
                    return Math.min(2000, resource.getAmount());
                }
                return Math.min(2000 - this.inputTank.getFluid().getAmount(), resource.getAmount());
            }
            if (this.inputTank.isEmpty()) {
                this.inputTank.fill(new FluidStack(resource, Math.min(2000, resource.getAmount())), IFluidHandler.FluidAction.EXECUTE);
                return this.inputTank.getFluid().getAmount();
            }
            int filledAmt = 2000 - this.inputTank.getFluid().getAmount();
            if (resource.getAmount() < filledAmt) {
                this.inputTank.getFluid().grow(resource.getAmount());
                filledAmt = resource.getAmount();
            } else {
                this.inputTank.getFluid().setAmount(2000);
            }
            if (filledAmt > 0) {
                // empty if block
            }
            return filledAmt;
        }

        public CompoundTag writeNBT() {
            CompoundTag inputNBT = new CompoundTag();
            this.inputTank.writeToNBT(inputNBT);
            CompoundTag outputNBT = new CompoundTag();
            this.outputTank.writeToNBT(outputNBT);
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("inputTank", (Tag)inputNBT);
            nbt.m_128365_("outputTank", (Tag)outputNBT);
            return nbt;
        }

        public void readNBT(CompoundTag nbt) {
            this.inputTank.readFromNBT(nbt.m_128469_("inputTank"));
            this.outputTank.readFromNBT(nbt.m_128469_("outputTank"));
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || resource.getFluid() != this.outputTank.getFluid().getFluid()) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            int drained = maxDrain;
            if (this.outputTank.getFluid().getAmount() < drained) {
                drained = this.outputTank.getFluid().getAmount();
            }
            FluidStack stack = new FluidStack(this.outputTank.getFluid(), drained);
            if (action.execute() && drained > 0) {
                this.outputTank.getFluid().shrink(drained);
            }
            return stack;
        }
    }
}

