/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerFeeder;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TileEntityFeeder
extends TileEntityInventoryBase
implements MenuProvider {
    public static final int THRESHOLD = 30;
    private static final int TIME = 100;
    public int currentTimer;
    public int currentAnimalAmount;
    private int lastAnimalAmount;
    private int lastTimer;

    public TileEntityFeeder(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.FEEDER.getTileEntityType(), pos, state, 1);
    }

    public int getCurrentTimerToScale(int i) {
        return this.currentTimer * i / 100;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        compound.m_128405_("Timer", this.currentTimer);
        if (type == TileEntityBase.NBTType.SYNC) {
            compound.m_128405_("Animals", this.currentAnimalAmount);
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.currentTimer = compound.m_128451_("Timer");
        if (type == TileEntityBase.NBTType.SYNC) {
            this.currentAnimalAmount = compound.m_128451_("Animals");
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFeeder) {
            TileEntityFeeder tile = (TileEntityFeeder)t;
            tile.clientTick();
            tile.currentTimer = Mth.m_14045_((int)(++tile.currentTimer), (int)0, (int)100);
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFeeder) {
            TileEntityFeeder tile = (TileEntityFeeder)t;
            tile.serverTick();
            tile.currentTimer = Mth.m_14045_((int)(++tile.currentTimer), (int)0, (int)100);
            int range = 5;
            ItemStack stack = tile.inv.getStackInSlot(0);
            if (!stack.m_41619_() && tile.currentTimer >= 100) {
                Optional<Animal> opt;
                List animals = level.m_45976_(Animal.class, new AABB(pos).m_82400_((double)range));
                tile.currentAnimalAmount = animals.size();
                if (tile.currentAnimalAmount >= 2 && tile.currentAnimalAmount < 30 && (opt = animals.stream().filter(e -> tile.canBeFed(stack, (Animal)e)).findAny()).isPresent()) {
                    tile.feedAnimal(opt.get());
                    stack.m_41774_(1);
                    tile.currentTimer = 0;
                    tile.m_6596_();
                }
            }
            if ((tile.lastAnimalAmount != tile.currentAnimalAmount || tile.lastTimer != tile.currentTimer) && tile.sendUpdateWithInterval()) {
                tile.lastAnimalAmount = tile.currentAnimalAmount;
                tile.lastTimer = tile.currentTimer;
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation;
    }

    private void feedAnimal(Animal animal) {
        animal.m_27595_(null);
        for (int i = 0; i < 7; ++i) {
            double d = animal.m_9236_().f_46441_.m_188583_() * 0.02;
            double d1 = animal.m_9236_().f_46441_.m_188583_() * 0.02;
            double d2 = animal.m_9236_().f_46441_.m_188583_() * 0.02;
            animal.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, animal.m_20185_() + (double)(animal.m_9236_().f_46441_.m_188501_() * animal.m_20205_() * 2.0f) - (double)animal.m_20205_(), animal.m_20186_() + 0.5 + (double)(animal.m_9236_().f_46441_.m_188501_() * animal.m_20206_()), animal.m_20189_() + (double)(animal.m_9236_().f_46441_.m_188501_() * animal.m_20205_() * 2.0f) - (double)animal.m_20205_(), d, d1, d2);
        }
    }

    private boolean canBeFed(ItemStack stack, Animal animal) {
        if (animal instanceof Horse && ((Horse)animal).m_30614_()) {
            Item item = stack.m_41720_();
            return animal.m_146764_() == 0 && !animal.m_27593_() && (item == Items.f_42436_ || item == Items.f_42677_);
        }
        return animal.m_146764_() == 0 && !animal.m_27593_() && animal.m_6898_(stack);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.actuallyadditions.feeder");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player p_createMenu_3_) {
        return new ContainerFeeder(windowId, playerInventory, this);
    }
}

