/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.farmer.FarmerResult;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.api.internal.IFarmer;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerFarmer;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityFarmer
extends TileEntityInventoryBase
implements IFarmer,
MenuProvider {
    private static final List<IFarmerBehavior> SORTED_FARMER_BEHAVIORS = new ArrayList<IFarmerBehavior>();
    public final CustomEnergyStorage storage = new CustomEnergyStorage(100000, 1000, 0);
    public final LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.storage);
    private int waitTime;
    private int checkX;
    private int checkY;
    private int lastEnergy;
    private static boolean sorted = false;

    public TileEntityFarmer(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.FARMER.getTileEntityType(), pos, state, 12);
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128405_("WaitTime", this.waitTime);
        }
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            compound.m_128405_("CheckX", this.checkX);
            compound.m_128405_("CheckY", this.checkY);
        }
        this.storage.writeToNBT(compound);
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.waitTime = compound.m_128451_("WaitTime");
        }
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            this.checkX = compound.m_128451_("CheckX");
            this.checkY = compound.m_128451_("CheckY");
        }
        this.storage.readFromNBT(compound);
        super.readSyncableNBT(compound, type);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFarmer) {
            TileEntityFarmer tile = (TileEntityFarmer)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFarmer) {
            TileEntityFarmer tile = (TileEntityFarmer)t;
            tile.serverTick();
            if (!tile.isRedstonePowered && tile.storage.getEnergyStored() > 0) {
                if (tile.waitTime > 0) {
                    --tile.waitTime;
                    if (tile.waitTime <= 0) {
                        int area = (Integer)CommonConfig.Machines.FARMER_AREA.get();
                        if (area % 2 == 0) {
                            ++area;
                        }
                        int radius = area / 2;
                        BlockPos center = pos.m_5484_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_), radius + 1);
                        BlockPos query = center.m_7918_(tile.checkX, 0, tile.checkY);
                        tile.checkBehaviors(query);
                        ++tile.checkX;
                        if (tile.checkX > radius) {
                            tile.checkX = -radius;
                            ++tile.checkY;
                            if (tile.checkY > radius) {
                                tile.checkY = -radius;
                            }
                        }
                    }
                } else {
                    tile.waitTime = 5;
                }
            }
            if (tile.lastEnergy != tile.storage.getEnergyStored() && tile.sendUpdateWithInterval()) {
                tile.lastEnergy = tile.storage.getEnergyStored();
            }
        }
    }

    private static void sort() {
        SORTED_FARMER_BEHAVIORS.clear();
        SORTED_FARMER_BEHAVIORS.addAll(ActuallyAdditionsAPI.FARMER_BEHAVIORS);
        Collections.sort(SORTED_FARMER_BEHAVIORS, (b1, b2) -> b2.getPrioInt().compareTo(b1.getPrioInt()));
        sorted = true;
    }

    private void checkBehaviors(BlockPos query) {
        if (!sorted) {
            TileEntityFarmer.sort();
        }
        for (IFarmerBehavior behavior : SORTED_FARMER_BEHAVIORS) {
            FarmerResult harvestResult = behavior.tryHarvestPlant((ServerLevel)this.f_58857_, query, this);
            if (harvestResult == FarmerResult.STOP_PROCESSING) {
                return;
            }
            for (int i = 0; i < 6; ++i) {
                ItemStack stack = this.inv.getStackInSlot(i);
                BlockState state = this.f_58857_.m_8055_(query);
                if (!StackUtil.isValid(stack) || !state.m_247087_()) continue;
                FarmerResult plantResult = behavior.tryPlantSeed(stack, this.f_58857_, query, this);
                if (plantResult == FarmerResult.SUCCESS) {
                    this.inv.getStackInSlot(i).m_41774_(1);
                    return;
                }
                if (plantResult != FarmerResult.STOP_PROCESSING) continue;
                return;
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || slot < 6;
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation || slot >= 6;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyStorage(Direction facing) {
        return this.lazyEnergy;
    }

    @Override
    public Direction getOrientation() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        return WorldUtil.getDirectionByPistonRotation(state);
    }

    @Override
    public BlockPos getPosition() {
        return this.f_58858_;
    }

    @Override
    public int getX() {
        return this.f_58858_.m_123341_();
    }

    @Override
    public int getY() {
        return this.f_58858_.m_123342_();
    }

    @Override
    public int getZ() {
        return this.f_58858_.m_123343_();
    }

    @Override
    public Level getWorldObject() {
        return this.f_58857_;
    }

    @Override
    public void extractEnergy(int amount) {
        this.storage.extractEnergyInternal(amount, false);
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public boolean canAddToSeeds(List<ItemStack> stacks) {
        return StackUtil.canAddAll(this.inv, stacks, 0, 6, false);
    }

    @Override
    public boolean canAddToOutput(List<ItemStack> stacks) {
        return StackUtil.canAddAll(this.inv, stacks, 6, 12, false);
    }

    @Override
    public void addToSeeds(List<ItemStack> stacks) {
        StackUtil.addAll(this.inv, stacks, 0, 6, false);
    }

    @Override
    public void addToOutput(List<ItemStack> stacks) {
        StackUtil.addAll(this.inv, stacks, 6, 12, false);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.actuallyadditions.farmer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player p_createMenu_3_) {
        return new ContainerFarmer(windowId, playerInventory, this);
    }
}

