/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.crafting.EmpowererRecipe;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityDisplayStand;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityEmpowerer
extends TileEntityInventoryBase {
    public int processTime;
    private EmpowererRecipe currentRecipe = null;
    private EmpowererRecipe lastRecipe = null;

    public EmpowererRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public TileEntityEmpowerer(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.EMPOWERER.getTileEntityType(), pos, state, 1);
    }

    public static boolean isPossibleInput(ItemStack stack) {
        for (EmpowererRecipe r : ActuallyAdditions.getRecipeManager().m_44013_((RecipeType)ActuallyRecipes.Types.EMPOWERING.get())) {
            if (!r.getInput().test(stack)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static EmpowererRecipe findMatchingRecipe(ItemStack base, ItemStack stand1, ItemStack stand2, ItemStack stand3, ItemStack stand4) {
        for (EmpowererRecipe r : ActuallyAdditions.getRecipeManager().m_44013_((RecipeType)ActuallyRecipes.Types.EMPOWERING.get())) {
            if (!r.matches(base, stand1, stand2, stand3, stand4)) continue;
            return r;
        }
        return null;
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityEmpowerer) {
            TileEntityEmpowerer tile = (TileEntityEmpowerer)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityEmpowerer) {
            TileEntityEmpowerer tile = (TileEntityEmpowerer)t;
            tile.serverTick();
            TileEntityDisplayStand[] stands = tile.getNearbyStands();
            if (stands != null) {
                EmpowererRecipe recipe = TileEntityEmpowerer.findMatchingRecipe(tile.inv.getStackInSlot(0), stands[0].getStack(), stands[1].getStack(), stands[2].getStack(), stands[3].getStack());
                if (recipe != null) {
                    tile.currentRecipe = recipe;
                    boolean hasPower = true;
                    for (TileEntityDisplayStand stand : stands) {
                        if (stand.storage.getEnergyStored() >= recipe.getEnergyPerStand() / recipe.getTime()) continue;
                        hasPower = false;
                    }
                    if (hasPower) {
                        ++tile.processTime;
                        boolean done = tile.processTime >= recipe.getTime();
                        for (TileEntityDisplayStand stand : stands) {
                            stand.storage.extractEnergyInternal(recipe.getEnergyPerStand() / recipe.getTime(), false);
                            if (!done) continue;
                            stand.inv.getStackInSlot(0).m_41774_(1);
                            stand.m_6596_();
                        }
                        if (tile.processTime % 5 == 0 && level instanceof ServerLevel) {
                            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123815_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5, 2, 0.0, 0.0, 0.0, 0.1);
                        }
                        if (done) {
                            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123810_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5, 100, 0.0, 0.0, 0.0, 0.25);
                            tile.inv.setStackInSlot(0, recipe.getOutput().m_41777_());
                            tile.m_6596_();
                            tile.processTime = 0;
                            tile.currentRecipe = null;
                        }
                    }
                } else {
                    tile.processTime = 0;
                    tile.currentRecipe = null;
                }
                if (tile.lastRecipe != tile.currentRecipe) {
                    tile.lastRecipe = tile.currentRecipe;
                    tile.sendUpdate();
                }
            }
        }
    }

    private TileEntityDisplayStand[] getNearbyStands() {
        TileEntityDisplayStand[] stands = new TileEntityDisplayStand[4];
        for (int i = 0; i <= 3; ++i) {
            Direction facing = Direction.m_122407_((int)i);
            BlockPos offset = this.f_58858_.m_5484_(facing, 3);
            BlockEntity tile = this.f_58857_.m_7702_(offset);
            if (!(tile instanceof TileEntityDisplayStand)) {
                return null;
            }
            stands[i] = (TileEntityDisplayStand)tile;
        }
        return stands;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            compound.m_128405_("ProcessTime", this.processTime);
        }
        if (type == TileEntityBase.NBTType.SYNC) {
            if (this.currentRecipe != null) {
                compound.m_128359_("CurrentRecipe", this.currentRecipe.m_6423_().toString());
            } else {
                compound.m_128359_("CurrentRecipe", "");
            }
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            this.processTime = compound.m_128451_("ProcessTime");
        }
        if (type == TileEntityBase.NBTType.SYNC && compound.m_128441_("CurrentRecipe")) {
            if (!compound.m_128461_("CurrentRecipe").isEmpty()) {
                ResourceLocation id = new ResourceLocation(compound.m_128461_("CurrentRecipe"));
                Optional<EmpowererRecipe> found = Stream.concat(this.f_58857_.m_7465_().m_44013_((RecipeType)ActuallyRecipes.Types.EMPOWERING.get()).stream(), ActuallyAdditionsAPI.EMPOWERER_RECIPES.stream()).filter(x -> x.m_6423_().equals((Object)id)).findFirst();
                found.ifPresent(empowererRecipe -> {
                    this.currentRecipe = empowererRecipe;
                });
            } else {
                this.currentRecipe = null;
            }
        }
    }

    @Override
    public boolean shouldSyncSlots() {
        return true;
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || TileEntityEmpowerer.isPossibleInput(stack);
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation || !TileEntityEmpowerer.isPossibleInput(this.inv.getStackInSlot(0));
    }

    @Override
    public int getMaxStackSize(int slot) {
        return 1;
    }
}

