/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.misc.IDisplayStandItem;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityDisplayStand
extends TileEntityInventoryBase
implements IEnergyDisplay {
    public final CustomEnergyStorage storage = new CustomEnergyStorage(80000, 1000, 0);
    public final LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.storage);
    private int oldEnergy;

    public TileEntityDisplayStand(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.DISPLAY_STAND.getTileEntityType(), pos, state, 1);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityDisplayStand) {
            TileEntityDisplayStand tile = (TileEntityDisplayStand)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityDisplayStand) {
            IDisplayStandItem item;
            TileEntityDisplayStand tile = (TileEntityDisplayStand)t;
            tile.serverTick();
            if (StackUtil.isValid(tile.inv.getStackInSlot(0)) && !tile.isRedstonePowered && (item = tile.convertToDisplayStandItem(tile.inv.getStackInSlot(0).m_41720_())) != null) {
                int energy = item.getUsePerTick(tile.inv.getStackInSlot(0), tile, tile.ticksElapsed);
                if (tile.storage.getEnergyStored() >= energy && item.update(tile.inv.getStackInSlot(0), tile, tile.ticksElapsed)) {
                    tile.storage.extractEnergyInternal(energy, false);
                }
            }
            if (tile.oldEnergy != tile.storage.getEnergyStored() && tile.sendUpdateWithInterval()) {
                tile.oldEnergy = tile.storage.getEnergyStored();
            }
        }
    }

    @Override
    public boolean shouldSyncSlots() {
        return true;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
    }

    private IDisplayStandItem convertToDisplayStandItem(Item item) {
        Block block;
        if (item instanceof IDisplayStandItem) {
            return (IDisplayStandItem)item;
        }
        if (item instanceof BlockItem && (block = Block.m_49814_((Item)item)) instanceof IDisplayStandItem) {
            return (IDisplayStandItem)block;
        }
        return null;
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public int getMaxStackSize(int slot) {
        return 1;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyStorage(Direction facing) {
        return this.lazyEnergy;
    }

    public ItemStack getStack() {
        return this.inv.getStackInSlot(0);
    }
}

