/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.AASounds;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.CrushingRecipe;
import de.ellpeck.actuallyadditions.mod.inventory.CrusherContainer;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.recipe.CrusherRecipeRegistry;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPoweredFurnace;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityCrusher
extends TileEntityInventoryBase
implements IButtonReactor,
MenuProvider {
    public static final int SLOT_INPUT_1 = 0;
    public static final int SLOT_OUTPUT_1_1 = 1;
    public static final int SLOT_OUTPUT_1_2 = 2;
    public static final int SLOT_INPUT_2 = 3;
    public static final int SLOT_OUTPUT_2_1 = 4;
    public static final int SLOT_OUTPUT_2_2 = 5;
    public static final int ENERGY_USE = 40;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(60000, 100, 0);
    public final LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.storage);
    public int firstCrushTime;
    public int secondCrushTime;
    public boolean isDouble;
    public boolean isAutoSplit;
    private int lastEnergy;
    private int lastFirstCrush;
    private int lastSecondCrush;
    private boolean lastAutoSplit;
    private boolean lastCrushed;

    public TileEntityCrusher(BlockEntityType<?> type, BlockPos pos, BlockState state, int slots) {
        super(type, pos, state, slots);
    }

    public TileEntityCrusher(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.CRUSHER.getTileEntityType(), pos, state, 3);
        this.isDouble = false;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128405_("FirstCrushTime", this.firstCrushTime);
            compound.m_128405_("SecondCrushTime", this.secondCrushTime);
            compound.m_128379_("IsAutoSplit", this.isAutoSplit);
        }
        this.storage.writeToNBT(compound);
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.firstCrushTime = compound.m_128451_("FirstCrushTime");
            this.secondCrushTime = compound.m_128451_("SecondCrushTime");
            this.isAutoSplit = compound.m_128471_("IsAutoSplit");
        }
        this.storage.readFromNBT(compound);
        super.readSyncableNBT(compound, type);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityCrusher) {
            TileEntityCrusher tile = (TileEntityCrusher)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityCrusher) {
            TileEntityCrusher tile = (TileEntityCrusher)t;
            tile.serverTick();
        }
    }

    @Override
    protected void serverTick() {
        boolean current;
        super.serverTick();
        if (this.isDouble && this.isAutoSplit) {
            TileEntityPoweredFurnace.autoSplit(this.inv, 0, 3);
        }
        boolean crushed = false;
        boolean canCrushOnFirst = this.canCrushOn(0, 1, 2);
        boolean canCrushOnSecond = false;
        if (this.isDouble) {
            canCrushOnSecond = this.canCrushOn(3, 4, 5);
        }
        boolean shouldPlaySound = false;
        if (canCrushOnFirst) {
            if (this.storage.getEnergyStored() >= 40) {
                if (this.firstCrushTime % 20 == 0) {
                    shouldPlaySound = true;
                }
                ++this.firstCrushTime;
                if (this.firstCrushTime >= this.getMaxCrushTime()) {
                    this.finishCrushing(0, 1, 2);
                    this.firstCrushTime = 0;
                }
                this.storage.extractEnergyInternal(40, false);
            }
            crushed = this.storage.getEnergyStored() >= 40;
        } else {
            this.firstCrushTime = 0;
        }
        if (this.isDouble) {
            if (canCrushOnSecond) {
                if (this.storage.getEnergyStored() >= 40) {
                    if (this.secondCrushTime % 20 == 0) {
                        shouldPlaySound = true;
                    }
                    ++this.secondCrushTime;
                    if (this.secondCrushTime >= this.getMaxCrushTime()) {
                        this.finishCrushing(3, 4, 5);
                        this.secondCrushTime = 0;
                    }
                    this.storage.extractEnergyInternal(40, false);
                }
                crushed = this.storage.getEnergyStored() >= 40;
            } else {
                this.secondCrushTime = 0;
            }
        }
        boolean changeTo = current = ((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue();
        if (this.lastCrushed != crushed) {
            changeTo = crushed;
        }
        if (this.isRedstonePowered) {
            changeTo = true;
        }
        if (!crushed && !this.isRedstonePowered) {
            changeTo = false;
        }
        if (changeTo != current) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(changeTo)));
        }
        this.lastCrushed = crushed;
        if ((this.lastEnergy != this.storage.getEnergyStored() || this.lastFirstCrush != this.firstCrushTime || this.lastSecondCrush != this.secondCrushTime || this.isAutoSplit != this.lastAutoSplit) && this.sendUpdateWithInterval()) {
            this.lastEnergy = this.storage.getEnergyStored();
            this.lastFirstCrush = this.firstCrushTime;
            this.lastSecondCrush = this.secondCrushTime;
            this.lastAutoSplit = this.isAutoSplit;
        }
        if (shouldPlaySound) {
            this.f_58857_.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (SoundEvent)AASounds.CRUSHER.get(), SoundSource.BLOCKS, 0.025f, 1.0f);
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || slot == 0 || slot == 3;
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation || slot == 1 || slot == 2 || slot == 4 || slot == 5;
    }

    public static Optional<CrushingRecipe> getRecipeForInput(ItemStack itemStack) {
        return Optional.ofNullable(CrusherRecipeRegistry.getRecipeFromInput(itemStack));
    }

    public boolean canCrushOn(int theInput, int theFirstOutput, int theSecondOutput) {
        ItemStack inputStack = this.inv.getStackInSlot(theInput);
        if (!inputStack.m_41619_()) {
            Optional<CrushingRecipe> recipeOpt = TileEntityCrusher.getRecipeForInput(inputStack);
            if (recipeOpt.isEmpty()) {
                return false;
            }
            CrushingRecipe recipe = recipeOpt.get();
            ItemStack outputOne = recipe.getOutputOne();
            ItemStack outputTwo = recipe.getOutputTwo();
            if (!outputOne.m_41619_()) {
                return (this.inv.getStackInSlot(theFirstOutput).m_41619_() || ItemStack.m_41656_((ItemStack)this.inv.getStackInSlot(theFirstOutput), (ItemStack)outputOne) && this.inv.getStackInSlot(theFirstOutput).m_41613_() <= this.inv.getStackInSlot(theFirstOutput).m_41741_() - outputOne.m_41613_()) && (outputTwo.m_41619_() || this.inv.getStackInSlot(theSecondOutput).m_41619_() || ItemStack.m_41656_((ItemStack)this.inv.getStackInSlot(theSecondOutput), (ItemStack)outputTwo) && this.inv.getStackInSlot(theSecondOutput).m_41613_() <= this.inv.getStackInSlot(theSecondOutput).m_41741_() - outputTwo.m_41613_());
            }
        }
        return false;
    }

    private int getMaxCrushTime() {
        return this.isDouble ? 150 : 100;
    }

    public void finishCrushing(int theInput, int theFirstOutput, int theSecondOutput) {
        float rand;
        ItemStack outputTwo;
        Optional<CrushingRecipe> recipeOpt = TileEntityCrusher.getRecipeForInput(this.inv.getStackInSlot(theInput));
        if (recipeOpt.isEmpty()) {
            return;
        }
        CrushingRecipe recipe = recipeOpt.get();
        ItemStack outputOne = recipe.getOutputOne();
        if (!outputOne.m_41619_()) {
            if (this.inv.getStackInSlot(theFirstOutput).m_41619_()) {
                this.inv.setStackInSlot(theFirstOutput, outputOne.m_41777_());
            } else if (this.inv.getStackInSlot(theFirstOutput).m_41720_() == outputOne.m_41720_()) {
                this.inv.setStackInSlot(theFirstOutput, StackUtil.grow(this.inv.getStackInSlot(theFirstOutput), outputOne.m_41613_()));
            }
        }
        if (!(outputTwo = recipe.getOutputTwo()).m_41619_() && (rand = this.f_58857_.f_46441_.m_188501_()) <= recipe.getSecondChance()) {
            if (this.inv.getStackInSlot(theSecondOutput).m_41619_()) {
                this.inv.setStackInSlot(theSecondOutput, outputTwo.m_41777_());
            } else if (this.inv.getStackInSlot(theSecondOutput).m_41720_() == outputTwo.m_41720_()) {
                this.inv.setStackInSlot(theSecondOutput, StackUtil.grow(this.inv.getStackInSlot(theSecondOutput), outputTwo.m_41613_()));
            }
        }
        this.inv.getStackInSlot(theInput).m_41774_(1);
    }

    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    public int getFirstTimeToScale(int i) {
        return this.firstCrushTime * i / this.getMaxCrushTime();
    }

    public int getSecondTimeToScale(int i) {
        return this.secondCrushTime * i / this.getMaxCrushTime();
    }

    @Override
    public void onButtonPressed(int buttonID, Player player) {
        if (buttonID == 0) {
            this.isAutoSplit = !this.isAutoSplit;
            this.m_6596_();
        }
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyStorage(Direction facing) {
        return this.lazyEnergy;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.actuallyadditions.crusher");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new CrusherContainer(windowId, playerInventory, this);
    }
}

