/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.AASounds;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.CoffeeIngredientRecipe;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.ItemCoffee;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TileEntityCoffeeMachine
extends TileEntityInventoryBase
implements MenuProvider,
IButtonReactor,
ISharingFluidHandler {
    public static final int SLOT_COFFEE_BEANS = 0;
    public static final int SLOT_INPUT = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int CACHE_USE = 35;
    public static final int ENERGY_USED = 150;
    public static final int WATER_USE = 500;
    public static final int COFFEE_CACHE_MAX_AMOUNT = 300;
    public static final int TIME_USED = 500;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(300000, 250, 0);
    public final LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.storage);
    public final FluidTank tank = new FluidTank(4000){

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public boolean isFluidValid(FluidStack fluid) {
            return fluid.getFluid() == Fluids.f_76193_;
        }
    };
    public final LazyOptional<IFluidHandler> lazyTank = LazyOptional.of(() -> this.tank);
    public int coffeeCacheAmount;
    public int brewTime;
    private int lastEnergy;
    private int lastTank;
    private int lastCoffeeAmount;
    private int lastBrewTime;

    public TileEntityCoffeeMachine(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.COFFEE_MACHINE.getTileEntityType(), pos, state, 11);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCoffeeScaled(int i) {
        return this.coffeeCacheAmount * i / 300;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getWaterScaled(int i) {
        return this.tank.getFluidAmount() * i / this.tank.getCapacity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBrewScaled(int i) {
        return this.brewTime * i / 500;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        this.tank.writeToNBT(compound);
        compound.m_128405_("Cache", this.coffeeCacheAmount);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128405_("Time", this.brewTime);
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        this.tank.readFromNBT(compound);
        this.coffeeCacheAmount = compound.m_128451_("Cache");
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.brewTime = compound.m_128451_("Time");
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityCoffeeMachine) {
            TileEntityCoffeeMachine tile = (TileEntityCoffeeMachine)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityCoffeeMachine) {
            TileEntityCoffeeMachine tile = (TileEntityCoffeeMachine)t;
            tile.serverTick();
            tile.storeCoffee();
            if (tile.brewTime > 0 || tile.isRedstonePowered) {
                tile.brew();
            }
            if ((tile.coffeeCacheAmount != tile.lastCoffeeAmount || tile.storage.getEnergyStored() != tile.lastEnergy || tile.tank.getFluidAmount() != tile.lastTank || tile.brewTime != tile.lastBrewTime) && tile.sendUpdateWithInterval()) {
                tile.lastCoffeeAmount = tile.coffeeCacheAmount;
                tile.lastEnergy = tile.storage.getEnergyStored();
                tile.lastTank = tile.tank.getFluidAmount();
                tile.lastBrewTime = tile.brewTime;
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || slot >= 3 && ItemCoffee.getIngredientRecipeFromStack(stack) != null || slot == 0 && stack.m_204117_(ActuallyTags.Items.COFFEE_BEANS) || slot == 1 && stack.m_41720_() == ActuallyItems.EMPTY_CUP.get();
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation || slot == 2 || slot >= 3 && slot < this.inv.getSlots() && ItemCoffee.getIngredientRecipeFromStack(this.inv.getStackInSlot(slot)) == null;
    }

    public void storeCoffee() {
        int toAdd;
        if (StackUtil.isValid(this.inv.getStackInSlot(0)) && this.inv.getStackInSlot(0).m_204117_(ActuallyTags.Items.COFFEE_BEANS) && (toAdd = 2) <= 300 - this.coffeeCacheAmount) {
            this.inv.setStackInSlot(0, StackUtil.shrink(this.inv.getStackInSlot(0), 1));
            this.coffeeCacheAmount += toAdd;
        }
    }

    public void brew() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        ItemStack input = this.inv.getStackInSlot(1);
        if (!input.m_41619_() && input.m_150930_((Item)ActuallyItems.EMPTY_CUP.get()) && this.inv.getStackInSlot(2).m_41619_() && this.coffeeCacheAmount >= 35 && this.tank.getFluid().getFluid() == Fluids.f_76193_ && this.tank.getFluidAmount() >= 500) {
            if (this.storage.getEnergyStored() >= 150) {
                if (this.brewTime % 30 == 0) {
                    this.f_58857_.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (SoundEvent)AASounds.COFFEE_MACHINE.get(), SoundSource.BLOCKS, 0.1f, 1.0f);
                }
                ++this.brewTime;
                this.storage.extractEnergyInternal(150, false);
                if (this.brewTime >= 500) {
                    this.brewTime = 0;
                    ItemStack output = new ItemStack((ItemLike)ActuallyItems.COFFEE_CUP.get());
                    for (int i = 3; i < this.inv.getSlots(); ++i) {
                        CoffeeIngredientRecipe recipeHolder;
                        if (this.inv.getStackInSlot(i).m_41619_() || (recipeHolder = ItemCoffee.getIngredientRecipeFromStack(this.inv.getStackInSlot(i))) == null || !recipeHolder.effect(output)) continue;
                        this.inv.setStackInSlot(i, StackUtil.shrinkForContainer(this.inv.getStackInSlot(i), 1));
                    }
                    this.inv.setStackInSlot(2, output.m_41777_());
                    this.inv.getStackInSlot(1).m_41774_(1);
                    this.coffeeCacheAmount -= 35;
                    this.tank.drain(500, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        } else {
            this.brewTime = 0;
        }
    }

    @Override
    public void onButtonPressed(int buttonID, Player player) {
        if (buttonID == 0 && this.brewTime <= 0) {
            this.brew();
        }
    }

    @Override
    public LazyOptional<IFluidHandler> getFluidHandler(Direction facing) {
        return this.lazyTank;
    }

    @Override
    public int getMaxFluidAmountToSplitShare() {
        return 0;
    }

    @Override
    public boolean doesShareFluid() {
        return false;
    }

    @Override
    public Direction[] getFluidShareSides() {
        return null;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyStorage(Direction facing) {
        return this.lazyEnergy;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.actuallyadditions.coffeeMachine");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new ContainerCoffeeMachine(windowId, playerInventory, this);
    }
}

