/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.crafting.SolidFuelRecipe;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerCoalGenerator;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityCoalGenerator
extends TileEntityInventoryBase
implements MenuProvider,
ISharingEnergyProvider,
IEnergyDisplay {
    public final CustomEnergyStorage storage = new CustomEnergyStorage(60000, 0, 80);
    public final LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.storage);
    public int maxBurnTime;
    public int currentBurnTime;
    private int lastEnergy;
    private int lastBurnTime;
    private int lastCurrentBurnTime;
    private int lastCompare;
    private SolidFuelRecipe currentRecipe = null;

    public TileEntityCoalGenerator(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.COAL_GENERATOR.getTileEntityType(), pos, state, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBurningScaled(int i) {
        return this.currentBurnTime * i / this.maxBurnTime;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128405_("BurnTime", this.currentBurnTime);
            compound.m_128405_("MaxBurnTime", this.maxBurnTime);
            if (this.currentRecipe != null) {
                compound.m_128359_("currentRecipe", this.currentRecipe.m_6423_().toString());
            }
        }
        this.storage.writeToNBT(compound);
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentBurnTime = compound.m_128451_("BurnTime");
            this.maxBurnTime = compound.m_128451_("MaxBurnTime");
            if (compound.m_128441_("currentRecipe")) {
                ResourceLocation id = new ResourceLocation(compound.m_128461_("currentRecipe"));
                this.f_58857_.m_7465_().m_44013_((RecipeType)ActuallyRecipes.Types.SOLID_FUEL.get()).stream().filter(x -> x.m_6423_().equals((Object)id)).findFirst().ifPresent(x -> {
                    this.currentRecipe = x;
                });
            }
        }
        this.storage.readFromNBT(compound);
        super.readSyncableNBT(compound, type);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityCoalGenerator) {
            TileEntityCoalGenerator tile = (TileEntityCoalGenerator)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityCoalGenerator) {
            boolean flag;
            TileEntityCoalGenerator tile = (TileEntityCoalGenerator)t;
            tile.serverTick();
            boolean bl = flag = tile.currentBurnTime > 0;
            if (tile.currentBurnTime > 0 && tile.currentRecipe != null) {
                --tile.currentBurnTime;
                int produce = tile.currentRecipe.getTotalEnergy() / tile.currentRecipe.getBurnTime();
                if (produce > 0) {
                    tile.storage.receiveEnergyInternal(produce, false);
                }
            }
            if (!tile.isRedstonePowered && tile.currentBurnTime <= 0 && tile.storage.getEnergyStored() < tile.storage.getMaxEnergyStored()) {
                ItemStack stack = tile.inv.getStackInSlot(0);
                if (!stack.m_41619_()) {
                    level.m_7465_().m_44013_((RecipeType)ActuallyRecipes.Types.SOLID_FUEL.get()).stream().filter(r -> r.matches(stack)).findFirst().ifPresent(recipe -> {
                        tile.currentRecipe = recipe;
                        tile.currentBurnTime = tile.maxBurnTime = recipe.getBurnTime();
                        tile.inv.setStackInSlot(0, StackUtil.shrinkForContainer(stack, 1));
                    });
                } else {
                    tile.currentRecipe = null;
                }
            }
            if (flag != tile.currentBurnTime > 0 || tile.lastCompare != tile.getComparatorStrength()) {
                tile.lastCompare = tile.getComparatorStrength();
                tile.m_6596_();
            }
            if ((tile.storage.getEnergyStored() != tile.lastEnergy || tile.currentBurnTime != tile.lastCurrentBurnTime || tile.lastBurnTime != tile.maxBurnTime) && tile.sendUpdateWithInterval()) {
                tile.lastEnergy = tile.storage.getEnergyStored();
                tile.lastCurrentBurnTime = tile.currentBurnTime;
                tile.lastBurnTime = tile.currentBurnTime;
            }
        }
    }

    @Override
    public int getComparatorStrength() {
        float calc = (float)this.storage.getEnergyStored() / (float)this.storage.getMaxEnergyStored() * 15.0f;
        return (int)calc;
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> this.f_58857_.m_7465_().m_44013_((RecipeType)ActuallyRecipes.Types.SOLID_FUEL.get()).stream().anyMatch(x -> x.matches(stack));
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> {
            if (!automation) {
                return true;
            }
            return ForgeHooks.getBurnTime((ItemStack)this.inv.getStackInSlot(0), null) <= 0;
        };
    }

    @Override
    public int getEnergyToSplitShare() {
        return this.storage.getEnergyStored();
    }

    @Override
    public boolean doesShareEnergy() {
        return true;
    }

    @Override
    public Direction[] getEnergyShareSides() {
        return Direction.values();
    }

    @Override
    public boolean canShareTo(BlockEntity tile) {
        return true;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyStorage(Direction facing) {
        return this.lazyEnergy;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.actuallyadditions.coalGenerator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new ContainerCoalGenerator(windowId, playerInventory, this);
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }
}

