/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerBreaker;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.items.IItemHandler;

public class TileEntityBreaker
extends TileEntityInventoryBase
implements MenuProvider {
    public boolean isPlacer;
    private int currentTime;

    public TileEntityBreaker(BlockEntityType<?> type, BlockPos pos, BlockState state, int slots) {
        super(type, pos, state, slots);
    }

    public TileEntityBreaker(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.BREAKER.getTileEntityType(), pos, state, 9);
        this.isPlacer = false;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128405_("CurrentTime", this.currentTime);
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentTime = compound.m_128451_("CurrentTime");
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityBreaker) {
            TileEntityBreaker tile = (TileEntityBreaker)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityBreaker) {
            TileEntityBreaker tile = (TileEntityBreaker)t;
            tile.serverTick();
            if (!tile.isRedstonePowered && !tile.isPulseMode) {
                if (tile.currentTime > 0) {
                    --tile.currentTime;
                    if (tile.currentTime <= 0) {
                        tile.doWork();
                    }
                } else {
                    tile.currentTime = 15;
                }
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation;
    }

    private void doWork() {
        Direction side = WorldUtil.getDirectionByPistonRotation(this.f_58857_.m_8055_(this.f_58858_));
        BlockPos breakCoords = this.f_58858_.m_121945_(side);
        BlockState stateToBreak = this.f_58857_.m_8055_(breakCoords);
        Block blockToBreak = stateToBreak.m_60734_();
        if (!this.isPlacer && blockToBreak != Blocks.f_50016_ && !(blockToBreak instanceof IFluidBlock) && stateToBreak.m_60800_((BlockGetter)this.f_58857_, breakCoords) >= 0.0f) {
            FakePlayer fake = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.f_58857_));
            ItemStack tool = this.inv.getStackInSlot(0);
            fake.m_150109_().f_35974_.set(fake.m_150109_().f_35977_, (Object)tool);
            List drops = Block.m_49874_((BlockState)stateToBreak, (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)breakCoords, (BlockEntity)this.f_58857_.m_7702_(breakCoords), (Entity)fake, (ItemStack)tool);
            if (!stateToBreak.canHarvestBlock((BlockGetter)this.f_58857_, breakCoords, (Player)fake)) {
                fake.m_150109_().f_35974_.set(fake.m_150109_().f_35977_, (Object)Items.f_42395_.m_7968_());
                tool = null;
            }
            if (stateToBreak.canHarvestBlock((BlockGetter)this.f_58857_, breakCoords, (Player)fake) && StackUtil.canAddAll(this.inv, drops, false)) {
                if (tool != null) {
                    tool.m_41622_(1, (LivingEntity)fake, e -> {});
                }
                this.f_58857_.m_46961_(breakCoords, false);
                StackUtil.addAll(this.inv, drops, false);
                this.m_6596_();
            }
        } else if (this.isPlacer) {
            int slot = StackUtil.findFirstFilled((IItemHandler)this.inv);
            if (slot == -1) {
                return;
            }
            this.inv.setStackInSlot(slot, WorldUtil.useItemAtSide(side, this.f_58857_, this.f_58858_, this.inv.getStackInSlot(slot)));
        }
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    @Nonnull
    public Component m_5446_() {
        return Component.m_237115_((String)(this.isPlacer ? "container.actuallyadditions.placer" : "container.actuallyadditions.breaker"));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
        return new ContainerBreaker(windowId, playerInventory, this);
    }
}

