/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.util.VanillaPacketDispatcher;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TileEntityBase
extends BlockEntity {
    public boolean isRedstonePowered;
    public boolean isPulseMode;
    public boolean stopFromDropping;
    protected int ticksElapsed;
    protected BlockEntity[] tilesAround = new BlockEntity[6];
    protected boolean hasSavedDataOnChangeOrWorldStart;
    private boolean shareEnergy = this instanceof ISharingEnergyProvider;
    private boolean shareFluid = this instanceof ISharingFluidHandler;

    public TileEntityBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.writeSyncableNBT(compound, NBTType.SAVE_TILE);
    }

    public void m_142466_(CompoundTag compound) {
        this.readSyncableNBT(compound, NBTType.SAVE_TILE);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag compound = new CompoundTag();
        this.writeSyncableNBT(compound, NBTType.SYNC);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.readSyncableNBT(pkt.m_131708_(), NBTType.SYNC);
        }
    }

    public final CompoundTag m_5995_() {
        CompoundTag compound = new CompoundTag();
        this.writeSyncableNBT(compound, NBTType.SYNC);
        return compound;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readSyncableNBT(tag, NBTType.SYNC);
    }

    public final void sendUpdate() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    public void writeSyncableNBT(CompoundTag compound, NBTType type) {
        if (type != NBTType.SAVE_BLOCK) {
            super.m_183515_(compound);
        }
        if (type == NBTType.SAVE_TILE) {
            compound.m_128379_("Redstone", this.isRedstonePowered);
            compound.m_128405_("TicksElapsed", this.ticksElapsed);
            compound.m_128379_("StopDrop", this.stopFromDropping);
        } else if (type == NBTType.SYNC && this.stopFromDropping) {
            compound.m_128379_("StopDrop", this.stopFromDropping);
        }
        if (this.isRedstoneToggle() && (type != NBTType.SAVE_BLOCK || this.isPulseMode)) {
            compound.m_128379_("IsPulseMode", this.isPulseMode);
        }
    }

    public void readSyncableNBT(CompoundTag compound, NBTType type) {
        if (type != NBTType.SAVE_BLOCK) {
            super.m_142466_(compound);
        }
        if (type == NBTType.SAVE_TILE) {
            this.isRedstonePowered = compound.m_128471_("Redstone");
            this.ticksElapsed = compound.m_128451_("TicksElapsed");
            this.stopFromDropping = compound.m_128471_("StopDrop");
        } else if (type == NBTType.SYNC) {
            this.stopFromDropping = compound.m_128471_("StopDrop");
        }
        if (this.isRedstoneToggle() && compound.m_128441_("IsPulseMode")) {
            this.isPulseMode = compound.m_128471_("IsPulseMode");
        }
    }

    @Deprecated
    public String getNameForTranslation() {
        return "removeme";
    }

    public int getComparatorStrength() {
        return 0;
    }

    protected void clientTick() {
        ++this.ticksElapsed;
    }

    protected void serverTick() {
        ISharingFluidHandler handler;
        BlockEntity tile;
        int amount;
        Direction[] sides;
        int total;
        ISharingEnergyProvider provider;
        ++this.ticksElapsed;
        if (this.shareEnergy && (provider = (ISharingEnergyProvider)((Object)this)).doesShareEnergy() && (total = provider.getEnergyToSplitShare()) > 0) {
            sides = provider.getEnergyShareSides();
            amount = total / sides.length;
            if (amount <= 0) {
                amount = total;
            }
            for (Direction side : sides) {
                tile = this.tilesAround[side.ordinal()];
                if (tile == null || !provider.canShareTo(tile)) continue;
                WorldUtil.doEnergyInteraction(this, tile, side, amount);
            }
        }
        if (this.shareFluid && (handler = (ISharingFluidHandler)((Object)this)).doesShareFluid() && (total = handler.getMaxFluidAmountToSplitShare()) > 0) {
            sides = handler.getFluidShareSides();
            amount = total / sides.length;
            if (amount <= 0) {
                amount = total;
            }
            for (Direction side : sides) {
                tile = this.tilesAround[side.ordinal()];
                if (tile == null) continue;
                WorldUtil.doFluidInteraction(this, tile, side, amount);
            }
        }
        if (!this.hasSavedDataOnChangeOrWorldStart) {
            if (this.shouldSaveDataOnChangeOrWorldStart()) {
                this.saveDataOnChangeOrWorldStart();
            }
            this.hasSavedDataOnChangeOrWorldStart = true;
        }
    }

    public void saveDataOnChangeOrWorldStart() {
        for (Direction side : Direction.values()) {
            BlockPos pos = this.f_58858_.m_121945_(side);
            if (!this.f_58857_.m_46805_(pos)) continue;
            this.tilesAround[side.ordinal()] = this.f_58857_.m_7702_(pos);
        }
    }

    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return this instanceof ISharingEnergyProvider || this instanceof ISharingFluidHandler;
    }

    public void setRedstonePowered(boolean powered) {
        this.isRedstonePowered = powered;
        this.m_6596_();
    }

    public boolean canPlayerUse(Player player) {
        return player.m_20275_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5) <= 64.0 && !this.m_58901_() && this.f_58857_.m_7702_(this.f_58858_) == this;
    }

    protected boolean sendUpdateWithInterval() {
        if (this.ticksElapsed % 5 == 0) {
            this.sendUpdate();
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.getItemHandler(side).cast();
        }
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.getFluidHandler(side).cast();
        }
        if (capability == ForgeCapabilities.ENERGY) {
            return this.getEnergyStorage(side).cast();
        }
        return LazyOptional.empty();
    }

    public LazyOptional<IFluidHandler> getFluidHandler(Direction facing) {
        return LazyOptional.empty();
    }

    public LazyOptional<IEnergyStorage> getEnergyStorage(Direction facing) {
        return LazyOptional.empty();
    }

    public LazyOptional<IItemHandler> getItemHandler(Direction facing) {
        return LazyOptional.empty();
    }

    public boolean isRedstoneToggle() {
        return false;
    }

    public void activateOnPulse() {
    }

    public boolean respondsToPulses() {
        return this.isRedstoneToggle() && this.isPulseMode;
    }

    public static enum NBTType {
        SAVE_TILE,
        SYNC,
        SAVE_BLOCK;

    }
}

