/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.internal.IAtomicReconstructor;
import de.ellpeck.actuallyadditions.api.lens.ILensItem;
import de.ellpeck.actuallyadditions.api.lens.Lens;
import de.ellpeck.actuallyadditions.mod.AASounds;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityAtomicReconstructor
extends TileEntityInventoryBase
implements IEnergyDisplay,
IAtomicReconstructor {
    public static final int ENERGY_USE = 1000;
    public final CustomEnergyStorage storage;
    public final LazyOptional<IEnergyStorage> lazyEnergy;
    public int counter;
    private int currentTime;
    private int oldEnergy;
    private int ttl = 0;
    private int maxAge = 0;
    private int beamColor = 1797631;

    public TileEntityAtomicReconstructor(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.ATOMIC_RECONSTRUCTOR.getTileEntityType(), pos, state, 1);
        int power = (Integer)CommonConfig.Machines.RECONSTRUCTOR_POWER.get();
        int recieve = Mth.m_14167_((float)((float)power * 0.016666f));
        this.storage = new CustomEnergyStorage(power, recieve, 0);
        this.lazyEnergy = LazyOptional.of(() -> this.storage);
    }

    public static void shootLaser(IAtomicReconstructor tile, Level world, double startX, double startY, double startZ, double endX, double endY, double endZ, Lens currentLens) {
        world.m_6263_(null, startX, startY, startZ, (SoundEvent)AASounds.RECONSTRUCTOR.get(), SoundSource.BLOCKS, 0.35f, 1.0f);
        AssetUtil.spawnLaserWithTimeServer(world, startX, startY, startZ, endX, endY, endZ, currentLens.getColor(), 25, 0.0, 0.2f, 0.8f);
    }

    public AABB getRenderBoundingBox() {
        if (this.getProgress() > 0.0f) {
            return new AABB(this.getPosition(), this.getPosition().m_7918_(1, 1, 1).m_5484_((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_), 11));
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public int getTTL() {
        return this.ttl;
    }

    @Override
    public void resetBeam(int maxAge) {
        this.resetBeam(maxAge, 1797631);
    }

    @Override
    public void resetBeam(int maxAge, int color) {
        this.ttl = maxAge;
        this.maxAge = maxAge;
        this.beamColor = color;
    }

    public int getBeamColor() {
        return this.beamColor;
    }

    public float getProgress() {
        if (this.maxAge > 0) {
            return (float)this.ttl / (float)this.maxAge;
        }
        return 0.0f;
    }

    public void decTTL() {
        if (this.ttl > 0) {
            --this.ttl;
        }
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.m_128405_("CurrentTime", this.currentTime);
            compound.m_128405_("Counter", this.counter);
        }
        this.storage.writeToNBT(compound);
    }

    @Override
    public boolean shouldSyncSlots() {
        return true;
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentTime = compound.m_128451_("CurrentTime");
            this.counter = compound.m_128451_("Counter");
        }
        if (compound.m_128441_("Energy")) {
            this.storage.readFromNBT(compound);
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityAtomicReconstructor) {
            TileEntityAtomicReconstructor tile = (TileEntityAtomicReconstructor)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityAtomicReconstructor) {
            TileEntityAtomicReconstructor tile = (TileEntityAtomicReconstructor)t;
            tile.serverTick();
            if (!tile.isRedstonePowered && !tile.isPulseMode) {
                if (tile.currentTime > 0) {
                    --tile.currentTime;
                    if (tile.currentTime <= 0) {
                        ActuallyAdditionsAPI.methodHandler.invokeReconstructor(tile);
                    }
                } else {
                    tile.currentTime = 100;
                }
            }
            if (tile.oldEnergy != tile.storage.getEnergyStored() && tile.sendUpdateWithInterval()) {
                tile.oldEnergy = tile.storage.getEnergyStored();
                level.m_46717_(pos, ActuallyBlocks.ATOMIC_RECONSTRUCTOR.get());
            }
        }
    }

    @Override
    public Lens getLens() {
        Item item = this.inv.getStackInSlot(0).m_41720_();
        if (item instanceof ILensItem) {
            return ((ILensItem)item).getLens();
        }
        return ActuallyAdditionsAPI.lensDefaultConversion;
    }

    @Override
    public Direction getOrientation() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        return WorldUtil.getDirectionByPistonRotation(state);
    }

    @Override
    public BlockPos getPosition() {
        return this.f_58858_;
    }

    @Override
    public int getX() {
        return this.m_58899_().m_123341_();
    }

    @Override
    public int getY() {
        return this.m_58899_().m_123342_();
    }

    @Override
    public int getZ() {
        return this.m_58899_().m_123343_();
    }

    @Override
    public Level getWorldObject() {
        return this.m_58904_();
    }

    @Override
    public void extractEnergy(int amount) {
        this.storage.extractEnergyInternal(amount, false);
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !stack.m_41619_() && stack.m_41720_() instanceof ILensItem;
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        ActuallyAdditionsAPI.methodHandler.invokeReconstructor(this);
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyStorage(Direction facing) {
        return this.lazyEnergy;
    }
}

