/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotFilter;
import de.ellpeck.actuallyadditions.mod.items.DrillItem;
import de.ellpeck.actuallyadditions.mod.items.ItemTag;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class FilterSettings {
    public final ItemStackHandlerAA filterInventory;
    public boolean isWhitelist;
    public boolean respectMod;
    public boolean matchDamage;
    public boolean matchNBT;
    private boolean lastWhitelist;
    private boolean lastRespectMod;
    private boolean lastMatchDamage;
    private boolean lastMatchNBT;

    public FilterSettings(int slots, boolean defaultWhitelist, boolean defaultRespectMod, boolean defaultMatchDamage, boolean defaultMatchNBT) {
        this.filterInventory = new ItemStackHandlerAA(slots){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                FilterSettings.this.onContentsChanged();
            }
        };
        this.isWhitelist = defaultWhitelist;
        this.respectMod = defaultRespectMod;
        this.matchDamage = defaultMatchDamage;
        this.matchNBT = defaultMatchNBT;
    }

    public void onContentsChanged() {
    }

    public static boolean check(ItemStack stack, ItemStackHandlerAA filter, boolean whitelist, boolean mod, boolean damage, boolean nbt) {
        if (!stack.m_41619_()) {
            for (int i = 0; i < filter.getSlots(); ++i) {
                TagKey tag;
                ResourceLocation parsed;
                Optional<Tag> data;
                ItemStack slot = filter.getStackInSlot(i);
                if (slot.m_41619_()) continue;
                if (SlotFilter.isFilter(slot)) {
                    ItemStackHandlerAA inv = new ItemStackHandlerAA(24);
                    DrillItem.loadSlotsFromNBT((IItemHandlerModifiable)inv, slot);
                    for (int k = 0; k < inv.getSlots(); ++k) {
                        ItemStack filterSlot = inv.getStackInSlot(k);
                        if (filterSlot.m_41619_() || !FilterSettings.areEqualEnough(filterSlot, stack, mod, damage, nbt)) continue;
                        return whitelist;
                    }
                    continue;
                }
                if (!(slot.m_41720_() instanceof ItemTag && slot.m_41782_() ? (data = Optional.ofNullable(slot.m_41784_().m_128423_("ItemTag"))).isPresent() && (parsed = ResourceLocation.m_135820_((String)data.get().m_7916_())) != null && stack.m_204117_(tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)parsed)) : FilterSettings.areEqualEnough(slot, stack, mod, damage, nbt))) continue;
                return whitelist;
            }
        }
        return !whitelist;
    }

    private static boolean areEqualEnough(ItemStack first, ItemStack second, boolean mod, boolean damage, boolean nbt) {
        if (mod) {
            return FilterSettings.checkMod(first, second) && FilterSettings.checkDamage(first, second, damage);
        }
        return FilterSettings.checkItem(first, second, nbt) && FilterSettings.checkDamage(first, second, damage);
    }

    public static boolean checkDamage(ItemStack first, ItemStack second, boolean damage) {
        return !damage || first.m_41773_() == second.m_41773_();
    }

    public static boolean checkItem(ItemStack first, ItemStack second, boolean nbt) {
        return nbt ? ItemStack.m_150942_((ItemStack)first, (ItemStack)second) : ItemStack.m_41656_((ItemStack)first, (ItemStack)second);
    }

    public static boolean checkMod(ItemStack first, ItemStack second) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)first.m_41720_()).m_135827_().equals(BuiltInRegistries.f_257033_.m_7981_((Object)second.m_41720_()).m_135827_());
    }

    public void writeToNBT(CompoundTag tag, String name) {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("Whitelist", this.isWhitelist);
        compound.m_128379_("Mod", this.respectMod);
        compound.m_128379_("Damage", this.matchDamage);
        compound.m_128379_("NBT", this.matchNBT);
        compound.m_128365_("Items", (Tag)this.filterInventory.serializeNBT());
        tag.m_128365_(name, (Tag)compound);
    }

    public void readFromNBT(CompoundTag tag, String name) {
        CompoundTag compound = tag.m_128469_(name);
        this.isWhitelist = compound.m_128471_("Whitelist");
        this.respectMod = compound.m_128471_("Mod");
        this.matchDamage = compound.m_128471_("Damage");
        this.matchNBT = compound.m_128471_("NBT");
        this.filterInventory.deserializeNBT(compound.m_128469_("Items"));
    }

    public boolean needsUpdateSend() {
        return this.lastWhitelist != this.isWhitelist || this.lastRespectMod != this.respectMod || this.lastMatchDamage != this.matchDamage || this.lastMatchNBT != this.matchNBT;
    }

    public void updateLasts() {
        this.lastWhitelist = this.isWhitelist;
        this.lastRespectMod = this.respectMod;
        this.lastMatchDamage = this.matchDamage;
        this.lastMatchNBT = this.matchNBT;
    }

    public void onButtonPressed(int id) {
        if (id == Buttons.WHITELIST.ordinal()) {
            this.isWhitelist = !this.isWhitelist;
        } else if (id == Buttons.MOD.ordinal()) {
            this.respectMod = !this.respectMod;
        } else if (id == Buttons.DAMAGE.ordinal()) {
            this.matchDamage = !this.matchDamage;
        } else if (id == Buttons.NBT.ordinal()) {
            this.matchNBT = !this.matchNBT;
        }
    }

    public boolean check(ItemStack stack) {
        return !this.needsCheck() || FilterSettings.check(stack, this.filterInventory, this.isWhitelist, this.respectMod, this.matchDamage, this.matchNBT);
    }

    public boolean needsCheck() {
        for (int i = 0; i < this.filterInventory.getSlots(); ++i) {
            if (this.filterInventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return this.isWhitelist;
    }

    public static enum Buttons {
        WHITELIST,
        MOD,
        DAMAGE,
        NBT;

    }
}

