/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.EnergyStorage;

public class CustomItemEnergyStorage
extends EnergyStorage {
    private ItemStack item;

    public CustomItemEnergyStorage(ItemStack item, int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
        this.item = item;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        this.energy = this.getEnergyStored();
        int received = super.receiveEnergy(maxReceive, simulate);
        this.item.m_41784_().m_128405_("Energy", this.energy);
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        this.energy = this.getEnergyStored();
        int extracted = super.extractEnergy(maxExtract, simulate);
        this.item.m_41784_().m_128405_("Energy", this.energy);
        return extracted;
    }

    public void setEnergyStored(int energy) {
        this.energy = energy;
        this.item.m_41784_().m_128405_("Energy", energy);
    }

    public int getEnergyStored() {
        return Optional.ofNullable(this.item.m_41783_()).map(tag -> tag.m_128451_("Energy")).orElse(0);
    }

    public int extractEnergyInternal(int maxExtract, boolean simulate) {
        int before = this.maxExtract;
        this.maxExtract = Integer.MAX_VALUE;
        int toReturn = this.extractEnergy(maxExtract, simulate);
        this.maxExtract = before;
        return toReturn;
    }

    public int receiveEnergyInternal(int maxReceive, boolean simulate) {
        int before = this.maxReceive;
        this.maxReceive = Integer.MAX_VALUE;
        int toReturn = this.receiveEnergy(maxReceive, simulate);
        this.maxReceive = before;
        return toReturn;
    }
}

