/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.sack;

import de.ellpeck.actuallyadditions.mod.sack.SackData;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.server.ServerLifecycleHooks;

public class SackManager
extends SavedData {
    private static final String NAME = "actuallyadditions_sack_data";
    private static final SackManager blankClient = new SackManager();
    private static final HashMap<UUID, SackData> data = new HashMap();

    public static SackManager get() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            return (SackManager)ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_).m_8895_().m_164861_(SackManager::load, SackManager::new, NAME);
        }
        return blankClient;
    }

    public Optional<SackData> getSack(UUID uuid) {
        if (data.containsKey(uuid)) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public SackData getOrCreateSack(UUID uuid) {
        return data.computeIfAbsent(uuid, id -> {
            this.m_77762_();
            return new SackData((UUID)id);
        });
    }

    public void removeSack(UUID uuid) {
        this.getSack(uuid).ifPresent(backpack -> {
            backpack.getOptional().invalidate();
            data.remove(uuid);
            this.m_77762_();
        });
    }

    public LazyOptional<IItemHandler> getCapability(UUID uuid) {
        if (data.containsKey(uuid)) {
            return data.get(uuid).getOptional();
        }
        return LazyOptional.empty();
    }

    public LazyOptional<IItemHandler> getCapability(ItemStack stack) {
        UUID uuid;
        if (stack.m_41784_().m_128441_("UUID") && data.containsKey(uuid = stack.m_41783_().m_128342_("UUID"))) {
            return data.get(uuid).getOptional();
        }
        return LazyOptional.empty();
    }

    public Optional<ItemStackHandlerAA> getHandler(ItemStack stack) {
        UUID uuid;
        if (stack.m_41784_().m_128441_("UUID") && data.containsKey(uuid = stack.m_41783_().m_128342_("UUID"))) {
            return Optional.of(data.get(uuid).getSpecialHandler());
        }
        return Optional.empty();
    }

    public static SackManager load(CompoundTag nbt) {
        if (nbt.m_128441_("Sacks")) {
            ListTag list = nbt.m_128437_("Sacks", 10);
            list.forEach(sackNBT -> SackData.fromNBT((CompoundTag)sackNBT).ifPresent(sack -> data.put(sack.getUuid(), (SackData)sack)));
        }
        return new SackManager();
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag sacks = new ListTag();
        data.forEach((uuid, sackData) -> sacks.add((Object)sackData.toNBT()));
        compound.m_128365_("Sacks", (Tag)sacks);
        return compound;
    }
}

