/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.sack;

import de.ellpeck.actuallyadditions.mod.sack.SackManager;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class SackData {
    public static final int SIZE = 28;
    private final UUID uuid;
    private final ItemStackHandlerAA inventory;
    private final LazyOptional<IItemHandler> optional;
    public final Metadata meta = new Metadata();
    private final FilterSettings filter = new FilterSettings(4, false, false, false, false){

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
            SackManager.get().m_77762_();
        }
    };

    public LazyOptional<IItemHandler> getOptional() {
        return this.optional;
    }

    public IItemHandler getHandler() {
        return this.inventory;
    }

    public ItemStackHandlerAA getSpecialHandler() {
        return this.inventory;
    }

    public FilterSettings getFilter() {
        return this.filter;
    }

    public void updateAccessRecords(String player, long time) {
        if (this.meta.firstAccessedTime == 0L) {
            this.meta.firstAccessedTime = time;
            this.meta.firstAccessedPlayer = player;
        }
        this.meta.setLastAccessedTime(time);
        this.meta.setLastAccessedPlayer(player);
    }

    public SackData(UUID uuid) {
        this.uuid = uuid;
        this.inventory = new ItemStackHandlerAA(28){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SackManager.get().m_77762_();
            }
        };
        this.optional = LazyOptional.of(() -> this.inventory);
    }

    public SackData(UUID uuid, CompoundTag incoming) {
        this.uuid = uuid;
        this.inventory = new ItemStackHandlerAA(28){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SackManager.get().m_77762_();
            }
        };
        this.inventory.deserializeNBT(incoming.m_128469_("Inventory"));
        this.optional = LazyOptional.of(() -> this.inventory);
        if (incoming.m_128441_("Filter")) {
            this.filter.readFromNBT(incoming, "Filter");
        }
        if (incoming.m_128441_("Metadata")) {
            this.meta.deserializeNBT(incoming.m_128469_("Metadata"));
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public static Optional<SackData> fromNBT(CompoundTag nbt) {
        if (nbt.m_128441_("UUID")) {
            UUID uuid = nbt.m_128342_("UUID");
            return Optional.of(new SackData(uuid, nbt));
        }
        return Optional.empty();
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("UUID", this.uuid);
        nbt.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        this.filter.writeToNBT(nbt, "Filter");
        nbt.m_128365_("Metadata", (Tag)this.meta.serializeNBT());
        return nbt;
    }

    public static class Metadata
    implements INBTSerializable<CompoundTag> {
        private String firstAccessedPlayer = "";
        private long firstAccessedTime = 0L;
        private String lastAccessedPlayer = "";
        private long lastAccessedTime = 0L;

        public long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public void setLastAccessedTime(long lastAccessedTime) {
            this.lastAccessedTime = lastAccessedTime;
        }

        public String getLastAccessedPlayer() {
            return this.lastAccessedPlayer;
        }

        public void setLastAccessedPlayer(String lastAccessedPlayer) {
            this.lastAccessedPlayer = lastAccessedPlayer;
        }

        public long getFirstAccessedTime() {
            return this.firstAccessedTime;
        }

        public String getFirstAccessedPlayer() {
            return this.firstAccessedPlayer;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("firstPlayer", this.firstAccessedPlayer);
            nbt.m_128356_("firstTime", this.firstAccessedTime);
            nbt.m_128359_("lastPlayer", this.lastAccessedPlayer);
            nbt.m_128356_("lastTime", this.lastAccessedTime);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.firstAccessedPlayer = nbt.m_128461_("firstPlayer");
            this.firstAccessedTime = nbt.m_128454_("firstTime");
            this.lastAccessedPlayer = nbt.m_128461_("lastPlayer");
            this.lastAccessedTime = nbt.m_128454_("lastTime");
        }
    }
}

