/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.ellpeck.actuallyadditions.mod.particle.LaserItemParticleData;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class ParticleLaserItem
extends Particle {
    private final double otherX;
    private final double otherY;
    private final double otherZ;
    private final ItemStack stack;

    private ParticleLaserItem(ClientLevel world, double posX, double posY, double posZ, ItemStack stack, double motionY) {
        this(world, posX, posY, posZ, stack, motionY, 0.0, 0.0, 0.0);
    }

    public ParticleLaserItem(ClientLevel world, double posX, double posY, double posZ, ItemStack stack, double motionY, double otherX, double otherY, double otherZ) {
        super(world, posX + (world.f_46441_.m_188500_() - 0.5) / 8.0, posY, posZ + (world.f_46441_.m_188500_() - 0.5) / 8.0);
        this.stack = stack;
        this.otherX = otherX;
        this.otherY = otherY;
        this.otherZ = otherZ;
        this.f_107215_ = 0.0;
        this.f_107216_ = motionY;
        this.f_107217_ = 0.0;
        this.f_107225_ = 10;
        this.f_107219_ = false;
    }

    public void m_107274_() {
        super.m_107274_();
        if (this.otherX != 0.0 || this.otherY != 0.0 || this.otherZ != 0.0) {
            this.f_107208_.m_7106_(Factory.createData(this.stack, 0.0, 0.0, 0.0), this.otherX, this.otherY, this.otherZ, 0.0, -0.025, 0.0);
        }
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera renderInfo, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource renderBuffer = mc.m_91269_().m_110104_();
        Vec3 cam = renderInfo.m_90583_();
        PoseStack matrices = new PoseStack();
        matrices.m_85836_();
        matrices.m_85837_(this.f_107212_ - cam.f_82479_, this.f_107213_ - cam.f_82480_, this.f_107214_ - cam.f_82481_);
        matrices.m_85841_(0.3f, 0.3f, 0.3f);
        double boop = (double)Util.m_137550_() / 600.0;
        matrices.m_252781_(Axis.f_252436_.m_252977_((float)(boop * 40.0 % 360.0)));
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float ageRatio = (float)this.f_107224_ / (float)this.f_107225_;
        float color = this.f_107216_ < 0.0 ? 1.0f - ageRatio : ageRatio;
        int blockLight = this.f_107208_.m_45517_(LightLayer.BLOCK, BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_));
        int skyLight = this.f_107208_.m_45517_(LightLayer.SKY, BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_));
        AssetUtil.renderItemWithoutScrewingWithColors(this.stack, matrices, LightTexture.m_109885_((int)blockLight, (int)skyLight), OverlayTexture.f_118083_);
        matrices.m_85849_();
        renderBuffer.m_109911_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class Factory
    implements ParticleProvider<LaserItemParticleData> {
        public Factory(SpriteSet sprite) {
        }

        public Particle createParticle(LaserItemParticleData data, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleLaserItem(worldIn, x, y, z, data.stack, ySpeed, data.outputX, data.outputY, data.outputZ);
        }

        public static ParticleOptions createData(ItemStack stack, double outputX, double outputY, double outputZ) {
            return new LaserItemParticleData(stack, outputX, outputY, outputZ);
        }
    }
}

