/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.particle.ActuallyParticles;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class LaserItemParticleData
extends ParticleType<LaserItemParticleData>
implements ParticleOptions {
    private ParticleType<LaserItemParticleData> type;
    public static final Codec<LaserItemParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.f_41582_.fieldOf("stack").forGetter(d -> d.stack), (App)Codec.DOUBLE.fieldOf("outputX").forGetter(d -> d.outputX), (App)Codec.DOUBLE.fieldOf("outputY").forGetter(d -> d.outputY), (App)Codec.DOUBLE.fieldOf("outputZ").forGetter(d -> d.outputZ)).apply((Applicative)instance, LaserItemParticleData::new));
    protected final ItemStack stack;
    protected final double outputX;
    protected final double outputY;
    protected final double outputZ;
    static final ParticleOptions.Deserializer<LaserItemParticleData> DESERIALIZER = new ParticleOptions.Deserializer<LaserItemParticleData>(){

        public LaserItemParticleData fromCommand(ParticleType<LaserItemParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            String itemString = reader.readString();
            ResourceLocation itemLocation = ResourceLocation.m_135820_((String)itemString);
            Item item = itemLocation == null ? null : (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
            ItemStack stack = item == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)item);
            reader.expect(' ');
            double outputX = reader.readDouble();
            reader.expect(' ');
            double outputY = reader.readDouble();
            reader.expect(' ');
            double outputZ = reader.readDouble();
            return new LaserItemParticleData(type, stack, outputX, outputY, outputZ);
        }

        public LaserItemParticleData fromNetwork(ParticleType<LaserItemParticleData> type, FriendlyByteBuf buffer) {
            ItemStack stack = buffer.m_130267_();
            double outputX = buffer.readDouble();
            double outputY = buffer.readDouble();
            double outputZ = buffer.readDouble();
            return new LaserItemParticleData(type, stack, outputX, outputY, outputZ);
        }
    };

    public LaserItemParticleData(ParticleType<LaserItemParticleData> particleTypeData, ItemStack stack, double outputX, double outputY, double outputZ) {
        super(false, DESERIALIZER);
        this.type = particleTypeData;
        this.stack = stack;
        this.outputX = outputX;
        this.outputY = outputY;
        this.outputZ = outputZ;
    }

    public LaserItemParticleData(ItemStack stack, double outputX, double outputY, double outputZ) {
        this((ParticleType<LaserItemParticleData>)((ParticleType)ActuallyParticles.LASER_ITEM.get()), stack, outputX, outputY, outputZ);
    }

    public ParticleType<?> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeItemStack(this.stack, true);
        buffer.writeDouble(this.outputX);
        buffer.writeDouble(this.outputY);
        buffer.writeDouble(this.outputZ);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %s %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()), this.outputX, this.outputY, this.outputZ);
    }

    public Codec<LaserItemParticleData> m_7652_() {
        return CODEC;
    }
}

