/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.network;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.network.PacketClientToServer;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketServerToClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public final class PacketHandlerHelper {
    @OnlyIn(value=Dist.CLIENT)
    public static void sendButtonPacket(BlockEntity tile, int buttonId) {
        CompoundTag compound = new CompoundTag();
        BlockPos pos = tile.m_58899_();
        compound.m_128405_("X", pos.m_123341_());
        compound.m_128405_("Y", pos.m_123342_());
        compound.m_128405_("Z", pos.m_123343_());
        compound.m_128359_("WorldID", tile.m_58904_().m_46472_().m_135782_().toString());
        compound.m_128405_("PlayerID", Minecraft.m_91087_().f_91074_.m_19879_());
        compound.m_128405_("ButtonID", buttonId);
        PacketHandler.THE_NETWORK.sendToServer((Object)new PacketClientToServer(compound, PacketHandler.GUI_BUTTON_TO_TILE_HANDLER));
    }

    public static void syncPlayerData(Player player, boolean log) {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("Log", log);
        CompoundTag data = new CompoundTag();
        PlayerData.getDataFromPlayer(player).writeToNBT(data, false);
        compound.m_128365_("Data", (Tag)data);
        if (player instanceof ServerPlayer) {
            PacketHandler.THE_NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PacketServerToClient(compound, PacketHandler.SYNC_PLAYER_DATA));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendPlayerDataToServer(boolean log, int type) {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("Log", log);
        compound.m_128405_("Type", type);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            compound.m_128359_("World", player.m_9236_().m_46472_().m_135782_().toString());
            compound.m_128362_("UUID", player.m_20148_());
            PlayerData.PlayerSave data = PlayerData.getDataFromPlayer((Player)player);
            if (type == 0) {
                compound.m_128365_("Bookmarks", (Tag)data.saveBookmarks());
            } else if (type == 1) {
                compound.m_128379_("DidBookTutorial", data.didBookTutorial);
            } else if (type == 2) {
                compound.m_128365_("Trials", (Tag)data.saveTrials());
                int total = 0;
                for (IBookletChapter iBookletChapter : ActuallyAdditionsAPI.entryTrials.getAllChapters()) {
                }
                if (data.completedTrials.size() >= total) {
                    compound.m_128379_("Achievement", true);
                }
            }
            PacketHandler.THE_NETWORK.sendToServer((Object)new PacketClientToServer(compound, PacketHandler.PLAYER_DATA_TO_SERVER));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendNumberPacket(BlockEntity tile, double number, int id) {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("X", tile.m_58899_().m_123341_());
        compound.m_128405_("Y", tile.m_58899_().m_123342_());
        compound.m_128405_("Z", tile.m_58899_().m_123343_());
        compound.m_128359_("WorldID", tile.m_58904_().m_46472_().m_135782_().toString());
        compound.m_128405_("PlayerID", Minecraft.m_91087_().f_91074_.m_19879_());
        compound.m_128405_("NumberID", id);
        compound.m_128347_("Number", number);
        PacketHandler.THE_NETWORK.sendToServer((Object)new PacketClientToServer(compound, PacketHandler.GUI_NUMBER_TO_TILE_HANDLER));
    }
}

