/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.network;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import de.ellpeck.actuallyadditions.mod.network.IDataHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketClientToServer;
import de.ellpeck.actuallyadditions.mod.network.PacketServerToClient;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.network.gui.INumberReactor;
import de.ellpeck.actuallyadditions.mod.network.gui.IStringReactor;
import de.ellpeck.actuallyadditions.mod.particle.ParticleLaserItem;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public final class PacketHandler {
    public static final List<IDataHandler> DATA_HANDLERS = new ArrayList<IDataHandler>();
    public static final IDataHandler LASER_HANDLER = new IDataHandler(){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void handleData(CompoundTag compound, NetworkEvent.Context context) {
            AssetUtil.spawnLaserWithTimeClient(compound.m_128459_("StartX"), compound.m_128459_("StartY"), compound.m_128459_("StartZ"), compound.m_128459_("EndX"), compound.m_128459_("EndY"), compound.m_128459_("EndZ"), compound.m_128451_("Color"), compound.m_128451_("MaxAge"), compound.m_128459_("RotationTime"), compound.m_128457_("Size"), compound.m_128457_("Alpha"));
        }
    };
    public static final IDataHandler TILE_ENTITY_HANDLER = new IDataHandler(){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void handleData(CompoundTag compound, NetworkEvent.Context context) {
            BlockEntity tile;
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world != null && (tile = world.m_7702_(new BlockPos(compound.m_128451_("X"), compound.m_128451_("Y"), compound.m_128451_("Z")))) instanceof TileEntityBase) {
                ((TileEntityBase)tile).readSyncableNBT(compound.m_128469_("Data"), TileEntityBase.NBTType.SYNC);
            }
        }
    };
    public static final IDataHandler LASER_PARTICLE_HANDLER = new IDataHandler(){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void handleData(CompoundTag compound, NetworkEvent.Context context) {
            Minecraft mc = Minecraft.m_91087_();
            ItemStack stack = ItemStack.m_41712_((CompoundTag)compound);
            double inX = compound.m_128459_("InX") + 0.5;
            double inY = compound.m_128459_("InY") + 0.78;
            double inZ = compound.m_128459_("InZ") + 0.5;
            double outX = compound.m_128459_("OutX") + 0.5;
            double outY = compound.m_128459_("OutY") + 0.525;
            double outZ = compound.m_128459_("OutZ") + 0.5;
            mc.f_91073_.m_7106_(ParticleLaserItem.Factory.createData(stack, inX, inY, inZ), outX, outY, outZ, 0.0, 0.025, 0.0);
        }
    };
    public static final IDataHandler GUI_BUTTON_TO_TILE_HANDLER = (compound, context) -> {
        ServerLevel world = context.getSender().m_20194_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("WorldID"))));
        BlockEntity tile = world.m_7702_(new BlockPos(compound.m_128451_("X"), compound.m_128451_("Y"), compound.m_128451_("Z")));
        if (tile instanceof IButtonReactor) {
            IButtonReactor reactor = (IButtonReactor)tile;
            Entity entity = world.m_6815_(compound.m_128451_("PlayerID"));
            if (entity instanceof Player) {
                reactor.onButtonPressed(compound.m_128451_("ButtonID"), (Player)entity);
            }
        }
    };
    public static final IDataHandler GUI_BUTTON_TO_CONTAINER_HANDLER = (compound, context) -> {
        ServerLevel world = context.getSender().m_20194_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("WorldID"))));
        Entity entity = world.m_6815_(compound.m_128451_("PlayerID"));
        if (entity instanceof Player) {
            Player p = (Player)entity;
            AbstractContainerMenu container = p.f_36096_;
            if (container instanceof IButtonReactor) {
                IButtonReactor reactor = (IButtonReactor)container;
                reactor.onButtonPressed(compound.m_128451_("ButtonID"), (Player)entity);
            }
        }
    };
    public static final IDataHandler GUI_NUMBER_TO_TILE_HANDLER = (compound, context) -> {
        ServerLevel world = context.getSender().m_20194_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("WorldID"))));
        BlockEntity tile = world.m_7702_(new BlockPos(compound.m_128451_("X"), compound.m_128451_("Y"), compound.m_128451_("Z")));
        if (tile instanceof INumberReactor) {
            INumberReactor reactor = (INumberReactor)tile;
            reactor.onNumberReceived(compound.m_128459_("Number"), compound.m_128451_("NumberID"), (Player)world.m_6815_(compound.m_128451_("PlayerID")));
        }
    };
    public static final IDataHandler GUI_STRING_TO_TILE_HANDLER = (compound, context) -> {
        ServerLevel world = context.getSender().m_20194_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("WorldID"))));
        BlockEntity tile = world.m_7702_(new BlockPos(compound.m_128451_("X"), compound.m_128451_("Y"), compound.m_128451_("Z")));
        if (tile instanceof IStringReactor) {
            IStringReactor reactor = (IStringReactor)tile;
            reactor.onTextReceived(compound.m_128461_("Text"), compound.m_128451_("TextID"), (Player)world.m_6815_(compound.m_128451_("PlayerID")));
        }
    };
    public static final IDataHandler SYNC_PLAYER_DATA = new IDataHandler(){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void handleData(CompoundTag compound, NetworkEvent.Context context) {
            CompoundTag dataTag = compound.m_128469_("Data");
            ServerPlayer player = context.getSender();
            if (player != null) {
                PlayerData.getDataFromPlayer((Player)player).readFromNBT(dataTag, false);
                if (compound.m_128471_("Log")) {
                    ActuallyAdditions.LOGGER.info("Receiving (new or changed) Player Data for player " + player.m_7755_() + ".");
                }
            } else {
                ActuallyAdditions.LOGGER.error("Tried to receive Player Data for the current player, but he doesn't seem to be present!");
            }
        }
    };
    public static final IDataHandler PLAYER_DATA_TO_SERVER = (compound, context) -> {
        ServerLevel world = context.getSender().m_20194_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("World"))));
        ServerPlayer player = world.m_7654_().m_6846_().m_11259_(compound.m_128342_("UUID"));
        if (player != null) {
            PlayerData.PlayerSave data = PlayerData.getDataFromPlayer((Player)player);
            int type = compound.m_128451_("Type");
            if (type == 0) {
                data.loadBookmarks(compound.m_128437_("Bookmarks", 8));
            } else if (type == 1) {
                data.didBookTutorial = compound.m_128471_("DidBookTutorial");
            } else if (type == 2) {
                data.loadTrials(compound.m_128437_("Trials", 8));
                if (compound.m_128471_("Achievement")) {
                    // empty if block
                }
            }
            WorldData.get((Level)world).m_77762_();
            if (compound.m_128471_("Log")) {
                ActuallyAdditions.LOGGER.info("Receiving changed Player Data for player " + player.m_7755_() + ".");
            }
        } else {
            ActuallyAdditions.LOGGER.error("Tried to receive Player Data for UUID " + compound.m_128342_("UUID") + ", but he doesn't seem to be present!");
        }
    };
    private static final String PROTOCOL_VERSION = Integer.toString(4);
    public static final SimpleChannel THE_NETWORK = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("actuallyadditions", "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);

    public static void init() {
        THE_NETWORK.messageBuilder(PacketServerToClient.class, 0, NetworkDirection.PLAY_TO_CLIENT).decoder(PacketServerToClient::fromBytes).encoder(PacketServerToClient::toBytes).consumerNetworkThread(PacketServerToClient::handle).add();
        THE_NETWORK.messageBuilder(PacketClientToServer.class, 1, NetworkDirection.PLAY_TO_SERVER).decoder(PacketClientToServer::fromBytes).encoder(PacketClientToServer::toBytes).consumerNetworkThread(PacketClientToServer::handle).add();
        DATA_HANDLERS.add(LASER_HANDLER);
        DATA_HANDLERS.add(TILE_ENTITY_HANDLER);
        DATA_HANDLERS.add(GUI_BUTTON_TO_TILE_HANDLER);
        DATA_HANDLERS.add(GUI_STRING_TO_TILE_HANDLER);
        DATA_HANDLERS.add(GUI_NUMBER_TO_TILE_HANDLER);
        DATA_HANDLERS.add(SYNC_PLAYER_DATA);
        DATA_HANDLERS.add(GUI_BUTTON_TO_CONTAINER_HANDLER);
        DATA_HANDLERS.add(LASER_PARTICLE_HANDLER);
        DATA_HANDLERS.add(PLAYER_DATA_TO_SERVER);
    }

    public static void sendTo(Object msg, ServerPlayer player) {
        if (!(player instanceof FakePlayer)) {
            THE_NETWORK.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void sendToServer(Object msg) {
        THE_NETWORK.sendToServer(msg);
    }

    public static void send(Object msg, PacketDistributor.PacketTarget target) {
        THE_NETWORK.send(target, msg);
    }
}

