/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.network;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.network.IDataHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketClientToServer {
    private CompoundTag data;
    private IDataHandler handler;

    public PacketClientToServer() {
    }

    public PacketClientToServer(CompoundTag data, IDataHandler handler) {
        this.data = data;
        this.handler = handler;
    }

    public static PacketClientToServer fromBytes(FriendlyByteBuf buffer) {
        try {
            CompoundTag data = buffer.m_130260_();
            int handlerId = buffer.readInt();
            if (handlerId >= 0 && handlerId < PacketHandler.DATA_HANDLERS.size()) {
                return new PacketClientToServer(data, PacketHandler.DATA_HANDLERS.get(handlerId));
            }
        }
        catch (Exception e) {
            ActuallyAdditions.LOGGER.error("Something went wrong trying to receive a server packet!", (Throwable)e);
        }
        return new PacketClientToServer();
    }

    public static void toBytes(PacketClientToServer message, FriendlyByteBuf buffer) {
        buffer.m_130079_(message.data);
        buffer.writeInt(PacketHandler.DATA_HANDLERS.indexOf(message.handler));
    }

    public static void handle(PacketClientToServer message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (message.data != null && message.handler != null) {
                message.handler.handleData(message.data, (NetworkEvent.Context)ctx.get());
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

