/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl.farmer;

import de.ellpeck.actuallyadditions.api.farmer.FarmerResult;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.api.internal.IFarmer;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.farmer.DefaultFarmerBehavior;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class MelonPumpkinFarmerBehavior
implements IFarmerBehavior {
    @Override
    public FarmerResult tryPlantSeed(ItemStack seed, Level world, BlockPos pos, IFarmer farmer) {
        int use = 350;
        if (farmer.getEnergy() >= use * 2 && StackUtil.isValid(seed)) {
            boolean isPumpkin;
            Item seedItem = seed.m_41720_();
            boolean bl = isPumpkin = seedItem == Items.f_42577_;
            if (isPumpkin || seedItem == Items.f_42578_) {
                BlockState toPlant;
                if (pos.m_123341_() % 2 == 0 == (pos.m_123343_() % 2 == 0) && DefaultFarmerBehavior.defaultPlant(world, pos, toPlant = (isPumpkin ? Blocks.f_50189_ : Blocks.f_50190_).m_49966_(), farmer, use)) {
                    return FarmerResult.SUCCESS;
                }
                return FarmerResult.STOP_PROCESSING;
            }
            return FarmerResult.FAIL;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public FarmerResult tryHarvestPlant(ServerLevel world, BlockPos pos, IFarmer farmer) {
        BlockState state;
        Block block;
        int use = 500;
        if (farmer.getEnergy() >= use && ((block = (state = world.m_8055_(pos)).m_60734_()) == Blocks.f_50133_ || block == Blocks.f_50186_)) {
            List drops = state.m_287290_(new LootParams.Builder(world).m_287286_(LootContextParams.f_81460_, (Object)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_));
            if (!drops.isEmpty() && farmer.canAddToOutput(drops)) {
                world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                farmer.extractEnergy(use);
                farmer.addToOutput(drops);
                return FarmerResult.SUCCESS;
            }
            return FarmerResult.STOP_PROCESSING;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public int getPriority() {
        return 10;
    }
}

