/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl.farmer;

import de.ellpeck.actuallyadditions.api.farmer.FarmerResult;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.api.internal.IFarmer;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class DefaultFarmerBehavior
implements IFarmerBehavior {
    private static ItemStack hoe = ItemStack.f_41583_;

    public static boolean defaultPlant(Level world, BlockPos pos, BlockState toPlant, IFarmer farmer, int use) {
        if (toPlant != null) {
            BlockPos farmland = pos.m_7495_();
            BlockState farmlandState = world.m_8055_(farmland);
            if (farmlandState.m_204336_(BlockTags.f_144274_) || farmlandState.m_60713_(Blocks.f_50440_)) {
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                DefaultFarmerBehavior.useHoeAt(world, farmland);
                world.m_5594_(null, farmland, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                farmer.extractEnergy(use);
            }
            if (DefaultFarmerBehavior.tryPlant(toPlant, world, pos)) {
                farmer.extractEnergy(use);
                return true;
            }
        }
        return false;
    }

    private static boolean tryPlant(BlockState toPlant, Level world, BlockPos pos) {
        if (toPlant.m_60710_((LevelReader)world, pos)) {
            world.m_46597_(pos, toPlant);
            return true;
        }
        return false;
    }

    @Override
    public FarmerResult tryPlantSeed(ItemStack seed, Level world, BlockPos pos, IFarmer farmer) {
        int use = 350;
        if (farmer.getEnergy() >= use * 2 && DefaultFarmerBehavior.defaultPlant(world, pos, this.getPlantablePlantFromStack(seed, world, pos), farmer, use)) {
            return FarmerResult.SUCCESS;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public FarmerResult tryHarvestPlant(ServerLevel world, BlockPos pos, IFarmer farmer) {
        BlockState state;
        Block block;
        int use = 250;
        if (farmer.getEnergy() >= use && ((block = (state = world.m_8055_(pos)).m_60734_()) instanceof CropBlock ? ((CropBlock)block).m_52307_(state) : state.m_61138_((Property)BlockStateProperties.f_61409_) && (Integer)state.m_61143_((Property)BlockStateProperties.f_61409_) >= 7 && !(block instanceof StemBlock))) {
            return this.doFarmerStuff(state, world, pos, farmer);
        }
        return FarmerResult.FAIL;
    }

    private FarmerResult doFarmerStuff(BlockState state, ServerLevel serverLevel, BlockPos pos, IFarmer farmer) {
        ArrayList<ItemStack> seeds = new ArrayList<ItemStack>();
        ArrayList<ItemStack> other = new ArrayList<ItemStack>();
        List drops = state.m_287290_(new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_));
        if (drops.isEmpty()) {
            return FarmerResult.FAIL;
        }
        for (ItemStack stack : drops) {
            if (this.getPlantableFromStack(stack) != null) {
                seeds.add(stack);
                continue;
            }
            other.add(stack);
        }
        boolean addSeeds = true;
        if (!farmer.canAddToSeeds(seeds)) {
            other.addAll(seeds);
            addSeeds = false;
        }
        if (farmer.canAddToOutput(other)) {
            farmer.addToOutput(other);
            if (addSeeds) {
                farmer.addToSeeds(seeds);
            }
            serverLevel.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            serverLevel.m_46597_(pos, Blocks.f_50016_.m_49966_());
            farmer.extractEnergy(250);
            return FarmerResult.SUCCESS;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    private BlockState getPlantablePlantFromStack(ItemStack stack, Level world, BlockPos pos) {
        BlockState state;
        IPlantable plantable;
        if (StackUtil.isValid(stack) && (plantable = this.getPlantableFromStack(stack)) != null && (state = plantable.getPlant((BlockGetter)world, pos)) != null && state.m_60734_() instanceof BonemealableBlock) {
            return state;
        }
        return null;
    }

    private IPlantable getPlantableFromStack(ItemStack stack) {
        Block block;
        Item item = stack.m_41720_();
        if (item instanceof IPlantable) {
            return (IPlantable)item;
        }
        if (item instanceof BlockItem && (block = Block.m_49814_((Item)item)) instanceof IPlantable) {
            return (IPlantable)block;
        }
        return null;
    }

    private static ItemStack getHoeStack() {
        if (hoe.m_41619_()) {
            hoe = new ItemStack((ItemLike)Items.f_42392_);
        }
        return hoe;
    }

    public static InteractionResult useHoeAt(Level world, BlockPos pos) {
        FakePlayer player = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)world));
        ItemStack itemstack = DefaultFarmerBehavior.getHoeStack();
        if (!player.m_36204_(pos.m_121945_(Direction.UP), Direction.UP, itemstack)) {
            return InteractionResult.FAIL;
        }
        if (world.m_46859_(pos.m_7494_())) {
            BlockState state = world.m_8055_(pos);
            if (state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_152481_)) {
                world.m_46597_(pos, Blocks.f_50093_.m_49966_());
                return InteractionResult.SUCCESS;
            }
            if (state.m_204336_(BlockTags.f_144274_)) {
                world.m_46597_(pos, Blocks.f_50093_.m_49966_());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

